/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.client;

import com.google.common.annotations.Beta;
import io.pravega.schemaregistry.client.exceptions.RegistryExceptions;
import io.pravega.schemaregistry.contract.data.CodecType;
import io.pravega.schemaregistry.contract.data.Compatibility;
import io.pravega.schemaregistry.contract.data.EncodingId;
import io.pravega.schemaregistry.contract.data.EncodingInfo;
import io.pravega.schemaregistry.contract.data.GroupHistoryRecord;
import io.pravega.schemaregistry.contract.data.GroupProperties;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.contract.data.SchemaWithVersion;
import io.pravega.schemaregistry.contract.data.VersionInfo;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@Beta
public interface SchemaRegistryClient
extends AutoCloseable {
    public boolean addGroup(String var1, GroupProperties var2) throws RegistryExceptions.BadArgumentException, RegistryExceptions.UnauthorizedException;

    public void removeGroup(String var1) throws RegistryExceptions.UnauthorizedException;

    public Iterator<Map.Entry<String, GroupProperties>> listGroups() throws RegistryExceptions.UnauthorizedException;

    public GroupProperties getGroupProperties(String var1) throws RegistryExceptions.ResourceNotFoundException, RegistryExceptions.UnauthorizedException;

    public boolean updateCompatibility(String var1, Compatibility var2, @Nullable Compatibility var3) throws RegistryExceptions.ResourceNotFoundException, RegistryExceptions.UnauthorizedException;

    public List<SchemaWithVersion> getSchemas(String var1) throws RegistryExceptions.ResourceNotFoundException, RegistryExceptions.UnauthorizedException;

    public VersionInfo addSchema(String var1, SchemaInfo var2) throws RegistryExceptions.SchemaValidationFailedException, RegistryExceptions.SerializationMismatchException, RegistryExceptions.MalformedSchemaException, RegistryExceptions.ResourceNotFoundException, RegistryExceptions.UnauthorizedException;

    public void deleteSchemaVersion(String var1, VersionInfo var2) throws RegistryExceptions.ResourceNotFoundException, RegistryExceptions.UnauthorizedException;

    public SchemaInfo getSchemaForVersion(String var1, VersionInfo var2) throws RegistryExceptions.ResourceNotFoundException, RegistryExceptions.UnauthorizedException;

    public EncodingInfo getEncodingInfo(String var1, EncodingId var2) throws RegistryExceptions.ResourceNotFoundException, RegistryExceptions.UnauthorizedException;

    public EncodingId getEncodingId(String var1, VersionInfo var2, String var3) throws RegistryExceptions.CodecTypeNotRegisteredException, RegistryExceptions.ResourceNotFoundException, RegistryExceptions.UnauthorizedException;

    public SchemaWithVersion getLatestSchemaVersion(String var1, @Nullable String var2) throws RegistryExceptions.ResourceNotFoundException, RegistryExceptions.UnauthorizedException;

    public VersionInfo getVersionForSchema(String var1, SchemaInfo var2) throws RegistryExceptions.ResourceNotFoundException, RegistryExceptions.UnauthorizedException;

    public List<SchemaWithVersion> getSchemaVersions(String var1, @Nullable String var2) throws RegistryExceptions.ResourceNotFoundException, RegistryExceptions.UnauthorizedException;

    public boolean validateSchema(String var1, SchemaInfo var2) throws RegistryExceptions.ResourceNotFoundException, RegistryExceptions.UnauthorizedException;

    public boolean canReadUsing(String var1, SchemaInfo var2) throws RegistryExceptions.ResourceNotFoundException, RegistryExceptions.UnauthorizedException;

    public List<CodecType> getCodecTypes(String var1) throws RegistryExceptions.ResourceNotFoundException, RegistryExceptions.UnauthorizedException;

    public void addCodecType(String var1, CodecType var2) throws RegistryExceptions.ResourceNotFoundException, RegistryExceptions.UnauthorizedException;

    public List<GroupHistoryRecord> getGroupHistory(String var1) throws RegistryExceptions.ResourceNotFoundException, RegistryExceptions.UnauthorizedException;

    public Map<String, VersionInfo> getSchemaReferences(SchemaInfo var1) throws RegistryExceptions.ResourceNotFoundException, RegistryExceptions.UnauthorizedException;

    public String getNamespace();
}

