/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.common;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;

public class ContinuationTokenIterator<T, Token>
implements Iterator<T> {
    private final Object $lock = new Object[0];
    @GuardedBy(value="$lock")
    private final Queue<T> queue;
    private final Function<Token, Map.Entry<Token, Collection<T>>> loadingFunction;
    @GuardedBy(value="lock")
    private Token token;
    @GuardedBy(value="$lock")
    private T next;
    @GuardedBy(value="$lock")
    private boolean canHaveNext;

    public ContinuationTokenIterator(Function<Token, Map.Entry<Token, Collection<T>>> loadingFunction, Token tokenIdentity) {
        this.loadingFunction = loadingFunction;
        this.queue = new LinkedBlockingQueue<T>();
        this.token = tokenIdentity;
        this.canHaveNext = true;
        this.next = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Object object = this.$lock;
        synchronized (object) {
            T t = this.next = this.next == null ? this.queue.poll() : this.next;
            while (this.next == null && this.canHaveNext) {
                Map.Entry<Token, Collection<T>> result = this.loadingFunction.apply(this.token);
                this.token = result.getKey();
                this.queue.addAll(result.getValue());
                this.next = this.queue.poll();
                this.canHaveNext = this.next != null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        Object object = this.$lock;
        synchronized (object) {
            this.load();
            return this.canHaveNext;
        }
    }

    @Override
    public T next() {
        Object object = this.$lock;
        synchronized (object) {
            this.load();
            if (this.next != null) {
                T retVal = this.next;
                this.next = null;
                return retVal;
            }
            assert (!this.canHaveNext);
            throw new NoSuchElementException();
        }
    }
}

