/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.common;

import com.google.common.base.Preconditions;
import io.pravega.common.concurrent.Futures;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class FuturesUtility {
    public static <T, C> CompletableFuture<Map.Entry<C, List<T>>> filteredWithTokenAndLimit(BiFunction<C, Integer, CompletableFuture<Map.Entry<C, List<T>>>> retrieveFunction, Predicate<T> filter, C continuationToken, int limit, Executor executorService) {
        Preconditions.checkNotNull(retrieveFunction, (Object)"Retrieve function cannot be null");
        Preconditions.checkNotNull(filter, (Object)"filter cannot be null");
        Preconditions.checkNotNull((Object)executorService, (Object)"executor cannot be null");
        AtomicBoolean canContinue = new AtomicBoolean(true);
        AtomicInteger limitRemaining = new AtomicInteger(limit);
        AtomicReference token = new AtomicReference(continuationToken);
        LinkedList list = new LinkedList();
        return Futures.loop(canContinue::get, () -> ((CompletableFuture)retrieveFunction.apply(token.get(), limitRemaining.get())).thenAccept(result -> {
            List filtered = ((List)result.getValue()).stream().filter(filter).collect(Collectors.toList());
            int filteredOut = ((List)result.getValue()).size() - filtered.size();
            list.addAll(filtered);
            canContinue.set(filteredOut > 0 && ((List)result.getValue()).size() == limitRemaining.get());
            limitRemaining.set(limit - list.size());
            token.set(result.getKey());
        }), (Executor)executorService).thenApply(v -> new AbstractMap.SimpleEntry(token.get(), list));
    }
}

