/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.data;

import io.pravega.schemaregistry.contract.data.CodecType;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.contract.data.VersionInfo;
import lombok.NonNull;

public class EncodingInfo {
    @NonNull
    private final VersionInfo versionInfo;
    @NonNull
    private final SchemaInfo schemaInfo;
    @NonNull
    private final CodecType codecType;

    public EncodingInfo(@NonNull VersionInfo versionInfo, @NonNull SchemaInfo schemaInfo, @NonNull CodecType codecType) {
        if (versionInfo == null) {
            throw new NullPointerException("versionInfo is marked @NonNull but is null");
        }
        if (schemaInfo == null) {
            throw new NullPointerException("schemaInfo is marked @NonNull but is null");
        }
        if (codecType == null) {
            throw new NullPointerException("codecType is marked @NonNull but is null");
        }
        this.versionInfo = versionInfo;
        this.schemaInfo = schemaInfo;
        this.codecType = codecType;
    }

    @NonNull
    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    @NonNull
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    @NonNull
    public CodecType getCodecType() {
        return this.codecType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncodingInfo)) {
            return false;
        }
        EncodingInfo other = (EncodingInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        VersionInfo this$versionInfo = this.getVersionInfo();
        VersionInfo other$versionInfo = other.getVersionInfo();
        if (this$versionInfo == null ? other$versionInfo != null : !((Object)this$versionInfo).equals(other$versionInfo)) {
            return false;
        }
        SchemaInfo this$schemaInfo = this.getSchemaInfo();
        SchemaInfo other$schemaInfo = other.getSchemaInfo();
        if (this$schemaInfo == null ? other$schemaInfo != null : !((Object)this$schemaInfo).equals(other$schemaInfo)) {
            return false;
        }
        CodecType this$codecType = this.getCodecType();
        CodecType other$codecType = other.getCodecType();
        return !(this$codecType == null ? other$codecType != null : !((Object)this$codecType).equals(other$codecType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EncodingInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        VersionInfo $versionInfo = this.getVersionInfo();
        result = result * 59 + ($versionInfo == null ? 43 : ((Object)$versionInfo).hashCode());
        SchemaInfo $schemaInfo = this.getSchemaInfo();
        result = result * 59 + ($schemaInfo == null ? 43 : ((Object)$schemaInfo).hashCode());
        CodecType $codecType = this.getCodecType();
        result = result * 59 + ($codecType == null ? 43 : ((Object)$codecType).hashCode());
        return result;
    }

    public String toString() {
        return "EncodingInfo(versionInfo=" + this.getVersionInfo() + ", schemaInfo=" + this.getSchemaInfo() + ", codecType=" + this.getCodecType() + ")";
    }
}

