/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.generated.rest.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.pravega.schemaregistry.contract.generated.rest.model.BackwardAndForward;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;

@ApiModel(description="Compatibility policy.")
public class Compatibility {
    @JsonProperty(value="policy")
    private PolicyEnum policy = null;
    @JsonProperty(value="advanced")
    private BackwardAndForward advanced = null;

    public Compatibility policy(PolicyEnum policy) {
        this.policy = policy;
        return this;
    }

    @JsonProperty(value="policy")
    @ApiModelProperty(required=true, value="Compatibility policy enum.")
    @NotNull
    public PolicyEnum getPolicy() {
        return this.policy;
    }

    public void setPolicy(PolicyEnum policy) {
        this.policy = policy;
    }

    public Compatibility advanced(BackwardAndForward advanced) {
        this.advanced = advanced;
        return this;
    }

    @JsonProperty(value="advanced")
    @ApiModelProperty(value="Backward and forward policy details.")
    public BackwardAndForward getAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(BackwardAndForward advanced) {
        this.advanced = advanced;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Compatibility compatibility = (Compatibility)o;
        return Objects.equals((Object)this.policy, (Object)compatibility.policy) && Objects.equals(this.advanced, compatibility.advanced);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.policy, this.advanced});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Compatibility {\n");
        sb.append("    policy: ").append(this.toIndentedString((Object)this.policy)).append("\n");
        sb.append("    advanced: ").append(this.toIndentedString(this.advanced)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PolicyEnum {
        ALLOWANY("AllowAny"),
        DENYALL("DenyAll"),
        FORWARD("Forward"),
        BACKWARD("Backward"),
        BACKWARDTRANSITIVE("BackwardTransitive"),
        FORWARDTRANSITIVE("ForwardTransitive"),
        FULL("Full"),
        FULLTRANSITIVE("FullTransitive"),
        ADVANCED("Advanced");

        private String value;

        private PolicyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PolicyEnum fromValue(String text) {
            for (PolicyEnum b : PolicyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

