/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.generated.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.pravega.schemaregistry.contract.generated.rest.model.GroupProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;

@ApiModel(description="Map of Group names to group properties. For partially created groups, the group properties may be null.")
public class ListGroupsResponse {
    @JsonProperty(value="groups")
    private Map<String, GroupProperties> groups = null;
    @JsonProperty(value="continuationToken")
    private String continuationToken = null;

    public ListGroupsResponse groups(Map<String, GroupProperties> groups) {
        this.groups = groups;
        return this;
    }

    public ListGroupsResponse putGroupsItem(String key, GroupProperties groupsItem) {
        if (this.groups == null) {
            this.groups = new HashMap<String, GroupProperties>();
        }
        this.groups.put(key, groupsItem);
        return this;
    }

    @JsonProperty(value="groups")
    @ApiModelProperty(value="")
    public Map<String, GroupProperties> getGroups() {
        return this.groups;
    }

    public void setGroups(Map<String, GroupProperties> groups) {
        this.groups = groups;
    }

    public ListGroupsResponse continuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
        return this;
    }

    @JsonProperty(value="continuationToken")
    @ApiModelProperty(required=true, value="Continuation token to identify the position of last group in the response.")
    @NotNull
    public String getContinuationToken() {
        return this.continuationToken;
    }

    public void setContinuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListGroupsResponse listGroupsResponse = (ListGroupsResponse)o;
        return Objects.equals(this.groups, listGroupsResponse.groups) && Objects.equals(this.continuationToken, listGroupsResponse.continuationToken);
    }

    public int hashCode() {
        return Objects.hash(this.groups, this.continuationToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListGroupsResponse {\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    continuationToken: ").append(this.toIndentedString(this.continuationToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

