/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.generated.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.pravega.schemaregistry.contract.generated.rest.model.SchemaInfo;
import io.pravega.schemaregistry.contract.generated.rest.model.VersionInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;

@ApiModel(description="Object that encapsulates SchemaInfo and its corresponding VersionInfo objects.")
public class SchemaWithVersion {
    @JsonProperty(value="schemaInfo")
    private SchemaInfo schemaInfo = null;
    @JsonProperty(value="versionInfo")
    private VersionInfo versionInfo = null;

    public SchemaWithVersion schemaInfo(SchemaInfo schemaInfo) {
        this.schemaInfo = schemaInfo;
        return this;
    }

    @JsonProperty(value="schemaInfo")
    @ApiModelProperty(required=true, value="Schema information.")
    @NotNull
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public void setSchemaInfo(SchemaInfo schemaInfo) {
        this.schemaInfo = schemaInfo;
    }

    public SchemaWithVersion versionInfo(VersionInfo versionInfo) {
        this.versionInfo = versionInfo;
        return this;
    }

    @JsonProperty(value="versionInfo")
    @ApiModelProperty(required=true, value="Version information.")
    @NotNull
    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public void setVersionInfo(VersionInfo versionInfo) {
        this.versionInfo = versionInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaWithVersion schemaWithVersion = (SchemaWithVersion)o;
        return Objects.equals(this.schemaInfo, schemaWithVersion.schemaInfo) && Objects.equals(this.versionInfo, schemaWithVersion.versionInfo);
    }

    public int hashCode() {
        return Objects.hash(this.schemaInfo, this.versionInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SchemaWithVersion {\n");
        sb.append("    schemaInfo: ").append(this.toIndentedString(this.schemaInfo)).append("\n");
        sb.append("    versionInfo: ").append(this.toIndentedString(this.versionInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

