/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.transform;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.pravega.schemaregistry.contract.data.BackwardAndForward;
import io.pravega.schemaregistry.contract.data.Compatibility;
import io.pravega.schemaregistry.contract.data.EncodingId;
import io.pravega.schemaregistry.contract.data.GroupProperties;
import io.pravega.schemaregistry.contract.data.SchemaWithVersion;
import io.pravega.schemaregistry.contract.data.SerializationFormat;
import io.pravega.schemaregistry.contract.generated.rest.model.Backward;
import io.pravega.schemaregistry.contract.generated.rest.model.BackwardPolicy;
import io.pravega.schemaregistry.contract.generated.rest.model.BackwardTill;
import io.pravega.schemaregistry.contract.generated.rest.model.BackwardTransitive;
import io.pravega.schemaregistry.contract.generated.rest.model.CodecType;
import io.pravega.schemaregistry.contract.generated.rest.model.Compatibility;
import io.pravega.schemaregistry.contract.generated.rest.model.EncodingInfo;
import io.pravega.schemaregistry.contract.generated.rest.model.Forward;
import io.pravega.schemaregistry.contract.generated.rest.model.ForwardPolicy;
import io.pravega.schemaregistry.contract.generated.rest.model.ForwardTill;
import io.pravega.schemaregistry.contract.generated.rest.model.ForwardTransitive;
import io.pravega.schemaregistry.contract.generated.rest.model.GroupHistoryRecord;
import io.pravega.schemaregistry.contract.generated.rest.model.SchemaInfo;
import io.pravega.schemaregistry.contract.generated.rest.model.SerializationFormat;
import io.pravega.schemaregistry.contract.generated.rest.model.VersionInfo;
import java.nio.ByteBuffer;
import java.util.Map;

public class ModelHelper {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String BACKWARD = Backward.class.getSimpleName();
    private static final String BACKWARD_TRANSITIVE = BackwardTransitive.class.getSimpleName();
    private static final String BACKWARD_TILL = BackwardTill.class.getSimpleName();
    private static final String FORWARD = Forward.class.getSimpleName();
    private static final String FORWARD_TILL = ForwardTill.class.getSimpleName();
    private static final String FORWARD_TRANSITIVE = ForwardTransitive.class.getSimpleName();

    public static io.pravega.schemaregistry.contract.data.SchemaInfo decode(SchemaInfo schemaInfo) {
        Preconditions.checkArgument((schemaInfo != null ? 1 : 0) != 0, (Object)"SchemaInfo cannot be null");
        Preconditions.checkArgument((schemaInfo.getType() != null ? 1 : 0) != 0, (Object)"SchemaInfo type cannot be null");
        Preconditions.checkArgument((schemaInfo.getSerializationFormat() != null ? 1 : 0) != 0, (Object)"Serialization format cannot be null");
        Preconditions.checkArgument((schemaInfo.getSchemaData() != null ? 1 : 0) != 0, (Object)"schema data cannot be null");
        SerializationFormat serializationFormat = ModelHelper.decode(schemaInfo.getSerializationFormat());
        ImmutableMap properties = schemaInfo.getProperties() == null ? ImmutableMap.of() : ImmutableMap.copyOf(schemaInfo.getProperties());
        return new io.pravega.schemaregistry.contract.data.SchemaInfo(schemaInfo.getType(), serializationFormat, ByteBuffer.wrap(schemaInfo.getSchemaData()), (ImmutableMap<String, String>)properties);
    }

    public static SerializationFormat decode(io.pravega.schemaregistry.contract.generated.rest.model.SerializationFormat serializationFormat) {
        Preconditions.checkArgument((serializationFormat != null ? 1 : 0) != 0, (Object)"serialization format cannot be null");
        switch (serializationFormat.getSerializationFormat()) {
            case CUSTOM: {
                Preconditions.checkArgument((serializationFormat.getFullTypeName() != null ? 1 : 0) != 0, (Object)"Custom name not supplied");
                return SerializationFormat.custom(serializationFormat.getFullTypeName());
            }
        }
        return SerializationFormat.withName(ModelHelper.searchEnum(SerializationFormat.class, serializationFormat.getSerializationFormat().name()), serializationFormat.getFullTypeName());
    }

    public static Compatibility decode(io.pravega.schemaregistry.contract.generated.rest.model.Compatibility compatibility) {
        Compatibility decoded;
        if (compatibility.getPolicy() == null) {
            throw new IllegalArgumentException("Unknown compatibility type");
        }
        switch (compatibility.getPolicy()) {
            case ALLOWANY: {
                decoded = Compatibility.allowAny();
                break;
            }
            case BACKWARD: {
                decoded = Compatibility.backward();
                break;
            }
            case BACKWARDTRANSITIVE: {
                decoded = Compatibility.backwardTransitive();
                break;
            }
            case FORWARD: {
                decoded = Compatibility.forward();
                break;
            }
            case FORWARDTRANSITIVE: {
                decoded = Compatibility.forwardTransitive();
                break;
            }
            case FULL: {
                decoded = Compatibility.full();
                break;
            }
            case FULLTRANSITIVE: {
                decoded = Compatibility.fullTransitive();
                break;
            }
            case DENYALL: {
                decoded = Compatibility.denyAll();
                break;
            }
            case ADVANCED: {
                decoded = Compatibility.builder().type(Compatibility.Type.Advanced).backwardAndForward(ModelHelper.decode(compatibility.getAdvanced())).build();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown compatibility type");
            }
        }
        return decoded;
    }

    public static BackwardAndForward decode(io.pravega.schemaregistry.contract.generated.rest.model.BackwardAndForward compatibility) {
        Preconditions.checkArgument((compatibility.getBackwardPolicy() != null || compatibility.getForwardPolicy() != null ? 1 : 0) != 0, (Object)"At least one of Backward or Forward policy needs to be supplied for Advanced Compatibility");
        BackwardAndForward.BackwardAndForwardBuilder builder = BackwardAndForward.builder();
        if (compatibility.getBackwardPolicy() != null) {
            builder.backwardPolicy(ModelHelper.decode(compatibility.getBackwardPolicy()));
        }
        if (compatibility.getForwardPolicy() != null) {
            builder.forwardPolicy(ModelHelper.decode(compatibility.getForwardPolicy()));
        }
        return builder.build();
    }

    public static BackwardAndForward.BackwardPolicy decode(BackwardPolicy backward) {
        Preconditions.checkArgument((backward != null ? 1 : 0) != 0, (Object)"backward policy cannot be null");
        Object obj = backward.getBackwardPolicy();
        if (backward.getBackwardPolicy() instanceof Map) {
            String name = (String)((Map)backward.getBackwardPolicy()).get("name");
            if (name.equals(BACKWARD)) {
                obj = MAPPER.convertValue(backward.getBackwardPolicy(), Backward.class);
            } else if (name.equals(BACKWARD_TRANSITIVE)) {
                obj = MAPPER.convertValue(backward.getBackwardPolicy(), BackwardTransitive.class);
            } else if (name.equals(BACKWARD_TILL)) {
                obj = MAPPER.convertValue(backward.getBackwardPolicy(), BackwardTill.class);
            } else {
                throw new IllegalArgumentException("Backward policy needs to be one of Backward, BackwardTill or BackwardTransitive");
            }
        }
        if (obj instanceof Backward) {
            return new BackwardAndForward.Backward();
        }
        if (obj instanceof BackwardTill) {
            return new BackwardAndForward.BackwardTill(ModelHelper.decode(((BackwardTill)obj).getVersionInfo()));
        }
        if (obj instanceof BackwardTransitive) {
            return new BackwardAndForward.BackwardTransitive();
        }
        throw new IllegalArgumentException("Backward policy needs to be one of Backward, BackwardTill or BackwardTransitive.");
    }

    public static BackwardAndForward.ForwardPolicy decode(ForwardPolicy forward) {
        Preconditions.checkArgument((forward != null ? 1 : 0) != 0, (Object)"forward policy cannot be null");
        Object obj = forward.getForwardPolicy();
        if (forward.getForwardPolicy() instanceof Map) {
            String name = (String)((Map)forward.getForwardPolicy()).get("name");
            if (name.equals(FORWARD)) {
                obj = MAPPER.convertValue(forward.getForwardPolicy(), Forward.class);
            } else if (name.equals(FORWARD_TRANSITIVE)) {
                obj = MAPPER.convertValue(forward.getForwardPolicy(), ForwardTransitive.class);
            } else if (name.equals(FORWARD_TILL)) {
                obj = MAPPER.convertValue(forward.getForwardPolicy(), ForwardTill.class);
            } else {
                throw new IllegalArgumentException("Forward policy needs to be one of Forward, ForwardTill or ForwardTransitive.");
            }
        }
        if (obj instanceof Forward) {
            return new BackwardAndForward.Forward();
        }
        if (obj instanceof ForwardTill) {
            return new BackwardAndForward.ForwardTill(ModelHelper.decode(((ForwardTill)obj).getVersionInfo()));
        }
        if (obj instanceof ForwardTransitive) {
            return new BackwardAndForward.ForwardTransitive();
        }
        throw new IllegalArgumentException("Forward policy needs to be one of Forward, ForwardTill or ForwardTransitive.");
    }

    public static io.pravega.schemaregistry.contract.data.VersionInfo decode(VersionInfo versionInfo) {
        Preconditions.checkArgument((versionInfo != null ? 1 : 0) != 0, (Object)"Version info cannot be null");
        Preconditions.checkArgument((versionInfo.getType() != null ? 1 : 0) != 0, (Object)"type cannot be null");
        Preconditions.checkArgument((versionInfo.getVersion() != null ? 1 : 0) != 0, (Object)"version cannot be null");
        Preconditions.checkArgument((versionInfo.getId() != null ? 1 : 0) != 0, (Object)"id cannot be null");
        return new io.pravega.schemaregistry.contract.data.VersionInfo(versionInfo.getType(), versionInfo.getSerializationFormat(), versionInfo.getVersion(), versionInfo.getId());
    }

    public static io.pravega.schemaregistry.contract.data.EncodingInfo decode(EncodingInfo encodingInfo) {
        Preconditions.checkArgument((encodingInfo != null ? 1 : 0) != 0, (Object)"EncodingInfo cannot be null");
        Preconditions.checkArgument((encodingInfo.getVersionInfo() != null ? 1 : 0) != 0, (Object)"VersionInfo cannot be null");
        Preconditions.checkArgument((encodingInfo.getSchemaInfo() != null ? 1 : 0) != 0, (Object)"SchemaInfo cannot be null");
        Preconditions.checkArgument((encodingInfo.getCodecType() != null ? 1 : 0) != 0, (Object)"CodecType cannot be null");
        return new io.pravega.schemaregistry.contract.data.EncodingInfo(ModelHelper.decode(encodingInfo.getVersionInfo()), ModelHelper.decode(encodingInfo.getSchemaInfo()), ModelHelper.decode(encodingInfo.getCodecType()));
    }

    public static io.pravega.schemaregistry.contract.data.CodecType decode(CodecType codecType) {
        Preconditions.checkArgument((codecType != null ? 1 : 0) != 0, (Object)"CodecType cannot be null");
        Preconditions.checkArgument((codecType.getName() != null ? 1 : 0) != 0, (Object)"CodecType.name cannot be null");
        return codecType.getProperties() == null ? new io.pravega.schemaregistry.contract.data.CodecType(codecType.getName()) : new io.pravega.schemaregistry.contract.data.CodecType(codecType.getName(), (ImmutableMap<String, String>)ImmutableMap.copyOf(codecType.getProperties()));
    }

    public static SchemaWithVersion decode(io.pravega.schemaregistry.contract.generated.rest.model.SchemaWithVersion schemaWithVersion) {
        Preconditions.checkArgument((schemaWithVersion != null ? 1 : 0) != 0, (Object)"schema with version cannot be null");
        Preconditions.checkArgument((schemaWithVersion.getVersionInfo() != null ? 1 : 0) != 0, (Object)"VersionInfo cannot be null");
        Preconditions.checkArgument((schemaWithVersion.getSchemaInfo() != null ? 1 : 0) != 0, (Object)"SchemaInfo cannot be null");
        return new SchemaWithVersion(ModelHelper.decode(schemaWithVersion.getSchemaInfo()), ModelHelper.decode(schemaWithVersion.getVersionInfo()));
    }

    public static io.pravega.schemaregistry.contract.data.GroupHistoryRecord decode(GroupHistoryRecord historyRecord) {
        Preconditions.checkArgument((historyRecord != null ? 1 : 0) != 0, (Object)"history record be null");
        Preconditions.checkArgument((historyRecord.getSchemaInfo() != null ? 1 : 0) != 0, (Object)"schemaInfo be null");
        Preconditions.checkArgument((historyRecord.getVersionInfo() != null ? 1 : 0) != 0, (Object)"versionInfo be null");
        Preconditions.checkArgument((historyRecord.getTimestamp() != null ? 1 : 0) != 0, (Object)"Timestamp be null");
        Preconditions.checkArgument((historyRecord.getCompatibility() != null ? 1 : 0) != 0, (Object)"Compatibility be null");
        return new io.pravega.schemaregistry.contract.data.GroupHistoryRecord(ModelHelper.decode(historyRecord.getSchemaInfo()), ModelHelper.decode(historyRecord.getVersionInfo()), ModelHelper.decode(historyRecord.getCompatibility()), historyRecord.getTimestamp(), historyRecord.getSchemaString());
    }

    public static EncodingId decode(io.pravega.schemaregistry.contract.generated.rest.model.EncodingId encodingId) {
        Preconditions.checkArgument((encodingId != null ? 1 : 0) != 0, (Object)"EncodingId cannot be null");
        Preconditions.checkArgument((encodingId.getEncodingId() != null ? 1 : 0) != 0, (Object)"EncodingId cannot be null");
        Preconditions.checkArgument((encodingId.getEncodingId() != null ? 1 : 0) != 0);
        return new EncodingId(encodingId.getEncodingId());
    }

    public static GroupProperties decode(io.pravega.schemaregistry.contract.generated.rest.model.GroupProperties groupProperties) {
        Preconditions.checkArgument((groupProperties != null ? 1 : 0) != 0, (Object)"group properties cannot be null");
        Preconditions.checkArgument((groupProperties.isAllowMultipleTypes() != null ? 1 : 0) != 0, (Object)"is allow multiple type cannot be null");
        Preconditions.checkArgument((groupProperties.getSerializationFormat() != null ? 1 : 0) != 0, (Object)"serialization format cannot be null");
        Preconditions.checkArgument((groupProperties.getCompatibility() != null ? 1 : 0) != 0, (Object)"compatibility cannot be null");
        ImmutableMap properties = groupProperties.getProperties() == null ? ImmutableMap.of() : ImmutableMap.copyOf(groupProperties.getProperties());
        return GroupProperties.builder().serializationFormat(ModelHelper.decode(groupProperties.getSerializationFormat())).compatibility(ModelHelper.decode(groupProperties.getCompatibility())).allowMultipleTypes(groupProperties.isAllowMultipleTypes()).properties((ImmutableMap<String, String>)properties).build();
    }

    public static GroupHistoryRecord encode(io.pravega.schemaregistry.contract.data.GroupHistoryRecord groupHistoryRecord) {
        return new GroupHistoryRecord().schemaInfo(ModelHelper.encode(groupHistoryRecord.getSchemaInfo())).versionInfo(ModelHelper.encode(groupHistoryRecord.getVersionInfo())).compatibility(ModelHelper.encode(groupHistoryRecord.getCompatibility())).timestamp(groupHistoryRecord.getTimestamp()).schemaString(groupHistoryRecord.getSchemaString());
    }

    public static io.pravega.schemaregistry.contract.generated.rest.model.Compatibility encode(Compatibility compatibility) {
        io.pravega.schemaregistry.contract.generated.rest.model.Compatibility policy = new io.pravega.schemaregistry.contract.generated.rest.model.Compatibility().policy(ModelHelper.searchEnum(Compatibility.PolicyEnum.class, compatibility.getType().name()));
        if (policy.getPolicy().equals((Object)Compatibility.PolicyEnum.ADVANCED)) {
            policy.advanced(ModelHelper.encode(compatibility.getBackwardAndForward()));
        }
        return policy;
    }

    public static io.pravega.schemaregistry.contract.generated.rest.model.BackwardAndForward encode(BackwardAndForward backwardAndForward) {
        io.pravega.schemaregistry.contract.generated.rest.model.BackwardAndForward retVal = new io.pravega.schemaregistry.contract.generated.rest.model.BackwardAndForward();
        if (backwardAndForward.getBackwardPolicy() != null) {
            retVal.backwardPolicy(ModelHelper.encode(backwardAndForward.getBackwardPolicy()));
        }
        if (backwardAndForward.getForwardPolicy() != null) {
            retVal.forwardPolicy(ModelHelper.encode(backwardAndForward.getForwardPolicy()));
        }
        return retVal;
    }

    public static BackwardPolicy encode(BackwardAndForward.BackwardPolicy backwardPolicy) {
        if (backwardPolicy instanceof BackwardAndForward.Backward) {
            return new BackwardPolicy().backwardPolicy(new Backward().name(Backward.class.getSimpleName()));
        }
        if (backwardPolicy instanceof BackwardAndForward.BackwardTransitive) {
            return new BackwardPolicy().backwardPolicy(new BackwardTransitive().name(BackwardTransitive.class.getSimpleName()));
        }
        if (backwardPolicy instanceof BackwardAndForward.BackwardTill) {
            VersionInfo version = ModelHelper.encode(((BackwardAndForward.BackwardTill)backwardPolicy).getVersionInfo());
            return new BackwardPolicy().backwardPolicy(new BackwardTill().name(BackwardTill.class.getSimpleName()).versionInfo(version));
        }
        throw new IllegalArgumentException("Backward policy needs to be one of Backward BackwardTill or BackwardTransitive");
    }

    public static ForwardPolicy encode(BackwardAndForward.ForwardPolicy forwardPolicy) {
        if (forwardPolicy instanceof BackwardAndForward.Forward) {
            return new ForwardPolicy().forwardPolicy(new Forward().name(Forward.class.getSimpleName()));
        }
        if (forwardPolicy instanceof BackwardAndForward.ForwardTransitive) {
            return new ForwardPolicy().forwardPolicy(new ForwardTransitive().name(ForwardTransitive.class.getSimpleName()));
        }
        if (forwardPolicy instanceof BackwardAndForward.ForwardTill) {
            VersionInfo version = ModelHelper.encode(((BackwardAndForward.ForwardTill)forwardPolicy).getVersionInfo());
            return new ForwardPolicy().forwardPolicy(new ForwardTill().name(ForwardTill.class.getSimpleName()).versionInfo(version));
        }
        throw new IllegalArgumentException("Forward policy needs to be one of Forward ForwardTill or ForwardTransitive");
    }

    public static io.pravega.schemaregistry.contract.generated.rest.model.SchemaWithVersion encode(SchemaWithVersion schemaWithVersion) {
        return new io.pravega.schemaregistry.contract.generated.rest.model.SchemaWithVersion().schemaInfo(ModelHelper.encode(schemaWithVersion.getSchemaInfo())).versionInfo(ModelHelper.encode(schemaWithVersion.getVersionInfo()));
    }

    public static io.pravega.schemaregistry.contract.generated.rest.model.GroupProperties encode(GroupProperties groupProperties) {
        return new io.pravega.schemaregistry.contract.generated.rest.model.GroupProperties().serializationFormat(ModelHelper.encode(groupProperties.getSerializationFormat())).properties((Map<String, String>)groupProperties.getProperties()).allowMultipleTypes(groupProperties.isAllowMultipleTypes()).compatibility(ModelHelper.encode(groupProperties.getCompatibility()));
    }

    public static VersionInfo encode(io.pravega.schemaregistry.contract.data.VersionInfo versionInfo) {
        return new VersionInfo().type(versionInfo.getType()).serializationFormat(versionInfo.getSerializationFormatName()).version(versionInfo.getVersion()).id(versionInfo.getId());
    }

    public static SchemaInfo encode(io.pravega.schemaregistry.contract.data.SchemaInfo schemaInfo) {
        return new SchemaInfo().properties((Map<String, String>)schemaInfo.getProperties()).schemaData(schemaInfo.getSchemaData().array()).type(schemaInfo.getType()).serializationFormat(ModelHelper.encode(schemaInfo.getSerializationFormat()));
    }

    public static io.pravega.schemaregistry.contract.generated.rest.model.SerializationFormat encode(SerializationFormat serializationFormat) {
        if (serializationFormat.equals((Object)SerializationFormat.Custom)) {
            Preconditions.checkArgument((serializationFormat.getFullTypeName() != null ? 1 : 0) != 0);
            io.pravega.schemaregistry.contract.generated.rest.model.SerializationFormat serializationFormatModel = new io.pravega.schemaregistry.contract.generated.rest.model.SerializationFormat().serializationFormat(SerializationFormat.SerializationFormatEnum.CUSTOM);
            return serializationFormatModel.fullTypeName(serializationFormat.getFullTypeName());
        }
        return new io.pravega.schemaregistry.contract.generated.rest.model.SerializationFormat().serializationFormat(ModelHelper.searchEnum(SerializationFormat.SerializationFormatEnum.class, serializationFormat.name())).fullTypeName(serializationFormat.getFullTypeName());
    }

    public static io.pravega.schemaregistry.contract.generated.rest.model.EncodingId encode(EncodingId encodingId) {
        return new io.pravega.schemaregistry.contract.generated.rest.model.EncodingId().encodingId(encodingId.getId());
    }

    public static EncodingInfo encode(io.pravega.schemaregistry.contract.data.EncodingInfo encodingInfo) {
        return new EncodingInfo().codecType(ModelHelper.encode(encodingInfo.getCodecType())).versionInfo(ModelHelper.encode(encodingInfo.getVersionInfo())).schemaInfo(ModelHelper.encode(encodingInfo.getSchemaInfo()));
    }

    public static CodecType encode(io.pravega.schemaregistry.contract.data.CodecType codecType) {
        return new CodecType().name(codecType.getName()).properties((Map<String, String>)codecType.getProperties());
    }

    private static <T extends Enum<?>> T searchEnum(Class<T> enumeration, String search) {
        for (Enum each : (Enum[])enumeration.getEnumConstants()) {
            if (each.name().compareToIgnoreCase(search) != 0) continue;
            return (T)each;
        }
        throw new IllegalArgumentException(String.format("Value %s not found in enum %s", search, enumeration.getSimpleName()));
    }
}

