/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.shared.impl;

import com.google.common.base.Preconditions;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.contract.data.EncodingId;
import io.pravega.schemaregistry.contract.data.EncodingInfo;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.serializer.shared.impl.BaseDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.EncodingCache;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerConfig;
import io.pravega.schemaregistry.serializer.shared.schemas.Schema;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeserializer<T>
extends BaseDeserializer<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDeserializer.class);
    private static final int HEADER_SIZE = 5;
    private final String groupId;
    private final SchemaRegistryClient client;
    private final SchemaInfo schemaInfo;
    private final boolean encodeHeader;
    private final SerializerConfig.Decoders decoders;
    private final boolean skipHeaders;
    private final EncodingCache encodingCache;

    protected AbstractDeserializer(String groupId, SchemaRegistryClient client, @Nullable Schema<T> schema, boolean skipHeaders, SerializerConfig.Decoders decoders, EncodingCache encodingCache, boolean encodeHeader) {
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)client);
        Preconditions.checkNotNull((Object)encodingCache);
        this.groupId = groupId;
        this.client = client;
        this.encodingCache = encodingCache;
        this.schemaInfo = schema == null ? null : schema.getSchemaInfo();
        this.encodeHeader = encodeHeader;
        this.skipHeaders = skipHeaders;
        this.decoders = decoders;
        this.initialize();
    }

    private void initialize() {
        if (this.schemaInfo != null) {
            log.info("Validate caller supplied schema.");
            if (!this.client.canReadUsing(this.groupId, this.schemaInfo)) {
                throw new IllegalArgumentException("Cannot read using schema" + this.schemaInfo.getType() + " as it is considered incompatible with current policy.");
            }
        } else if (!this.encodeHeader) {
            log.warn("No reader schema is supplied and stream does not have encoding headers.");
        }
    }

    public T deserialize(ByteBuffer data) {
        SchemaInfo readerSchema;
        ByteArrayInputStream inputStream;
        SchemaInfo writerSchema;
        int start;
        int n = start = data.hasArray() ? data.arrayOffset() + data.position() : data.position();
        if (this.encodeHeader) {
            byte[] b;
            ByteBuffer decodedBytes;
            if (this.skipHeaders) {
                data.position(5);
                decodedBytes = data;
                writerSchema = null;
            } else {
                byte protocol = data.get();
                EncodingId encodingId = new EncodingId(data.getInt());
                EncodingInfo encodingInfo = this.encodingCache.getGroupEncodingInfo(encodingId);
                writerSchema = encodingInfo.getSchemaInfo();
                decodedBytes = this.decoders.decode(encodingInfo.getCodecType(), data);
            }
            if (decodedBytes.hasArray()) {
                b = decodedBytes.array();
                start = decodedBytes.arrayOffset() + decodedBytes.position();
            } else {
                b = new byte[decodedBytes.remaining()];
                decodedBytes.get(b);
                start = decodedBytes.position();
            }
            inputStream = new ByteArrayInputStream(b, start, decodedBytes.remaining());
            readerSchema = this.schemaInfo != null ? this.schemaInfo : writerSchema;
        } else {
            byte[] b;
            if (data.hasArray()) {
                b = data.array();
            } else {
                b = new byte[data.remaining()];
                data.get(b);
            }
            writerSchema = null;
            readerSchema = this.schemaInfo;
            inputStream = new ByteArrayInputStream(b, start, data.remaining());
        }
        return this.deserialize(inputStream, writerSchema, readerSchema);
    }

    public abstract T deserialize(InputStream var1, SchemaInfo var2, SchemaInfo var3) throws IOException;

    protected boolean isEncodeHeader() {
        return this.encodeHeader;
    }
}

