/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.shared.impl;

import com.google.common.base.Preconditions;
import io.pravega.common.io.ByteBufferOutputStream;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.contract.data.EncodingId;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.contract.data.VersionInfo;
import io.pravega.schemaregistry.serializer.shared.codec.Codecs;
import io.pravega.schemaregistry.serializer.shared.codec.Encoder;
import io.pravega.schemaregistry.serializer.shared.impl.BaseSerializer;
import io.pravega.schemaregistry.serializer.shared.schemas.Schema;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractSerializer<T>
extends BaseSerializer<T> {
    private static final byte PROTOCOL = 1;
    private final String groupId;
    private final SchemaInfo schemaInfo;
    private final AtomicReference<EncodingId> encodingId;
    private final boolean encodeHeader;
    private final SchemaRegistryClient client;
    private final Encoder encoder;
    private final boolean registerSchema;

    protected AbstractSerializer(String groupId, SchemaRegistryClient client, Schema<T> schema, Encoder encoder, boolean registerSchema, boolean encodeHeader) {
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)client);
        Preconditions.checkNotNull((Object)encoder);
        Preconditions.checkNotNull(schema);
        Preconditions.checkArgument((encodeHeader || encoder.equals(Codecs.None.getCodec()) ? 1 : 0) != 0, (Object)"Cannot use encoder if encoder header is false.");
        this.groupId = groupId;
        this.client = client;
        this.schemaInfo = schema.getSchemaInfo();
        this.registerSchema = registerSchema;
        this.encodingId = new AtomicReference();
        this.encoder = encoder;
        this.encodeHeader = encodeHeader;
        this.initialize();
    }

    private void initialize() {
        VersionInfo version = this.registerSchema ? this.client.addSchema(this.groupId, this.schemaInfo) : this.client.getVersionForSchema(this.groupId, this.schemaInfo);
        if (this.encodeHeader) {
            this.encodingId.set(this.client.getEncodingId(this.groupId, version, this.encoder.getCodecType().getName()));
        }
    }

    public ByteBuffer serialize(T obj) {
        ByteBufferOutputStream outStream = new ByteBufferOutputStream();
        if (this.encodeHeader) {
            outStream.write(1);
            outStream.writeInt(this.encodingId.get().getId());
        }
        if (!this.encodeHeader || this.encoder.equals(Codecs.None.getCodec())) {
            this.serialize(obj, this.schemaInfo, (OutputStream)outStream);
        } else {
            ByteBufferOutputStream serializedStream = new ByteBufferOutputStream();
            this.serialize(obj, this.schemaInfo, (OutputStream)serializedStream);
            this.encoder.encode(ByteBuffer.wrap(serializedStream.getData().array()), (OutputStream)outStream);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(outStream.getData().array(), 0, outStream.getData().getLength());
        return byteBuffer;
    }

    protected abstract void serialize(T var1, SchemaInfo var2, OutputStream var3) throws IOException;

    public Encoder getEncoder() {
        return this.encoder;
    }
}

