/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.shared.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.pravega.common.Exceptions;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.client.exceptions.RegistryExceptions;
import io.pravega.schemaregistry.contract.data.EncodingId;
import io.pravega.schemaregistry.contract.data.EncodingInfo;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;

public class EncodingCache {
    private static final int MAXIMUM_SIZE = 1000;
    private final LoadingCache<EncodingId, EncodingInfo> encodingCache;

    public EncodingCache(String groupId, SchemaRegistryClient schemaRegistryClient) {
        this(groupId, schemaRegistryClient, 1000);
    }

    @VisibleForTesting
    EncodingCache(final String groupId, final SchemaRegistryClient schemaRegistryClient, int cacheSize) {
        this.encodingCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build((CacheLoader)new CacheLoader<EncodingId, EncodingInfo>(){

            public EncodingInfo load(EncodingId key) {
                return schemaRegistryClient.getEncodingInfo(groupId, key);
            }
        });
    }

    EncodingInfo getGroupEncodingInfo(EncodingId encodingId) {
        try {
            return (EncodingInfo)this.encodingCache.get((Object)encodingId);
        }
        catch (ExecutionException e) {
            if (e.getCause() != null && Exceptions.unwrap((Throwable)e.getCause()) instanceof RegistryExceptions) {
                throw (RegistryExceptions)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    @VisibleForTesting
    ConcurrentMap<EncodingId, EncodingInfo> getMapForCache() {
        return this.encodingCache.asMap();
    }
}

