/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.client;

import io.pravega.schemaregistry.common.CredentialProvider;
import java.net.URI;

public class SchemaRegistryClientConfig {
    private final URI schemaRegistryUri;
    private final boolean authEnabled;
    private final CredentialProvider credentialProvider;
    private final String trustStore;
    private final String trustStoreType;
    private final String trustStorePassword;
    private final String certificate;
    private final boolean validateHostName;

    private SchemaRegistryClientConfig(URI schemaRegistryUri, boolean authEnabled, CredentialProvider credentialProvider, String trustStore, String trustStoreType, String trustStorePassword, String certificate, boolean validateHostName) {
        this.schemaRegistryUri = schemaRegistryUri;
        this.authEnabled = authEnabled;
        this.credentialProvider = credentialProvider;
        this.trustStore = trustStore;
        this.certificate = certificate;
        this.trustStoreType = trustStoreType;
        this.trustStorePassword = trustStorePassword;
        this.validateHostName = validateHostName;
    }

    public static SchemaRegistryClientConfigBuilder builder() {
        return new SchemaRegistryClientConfigBuilder();
    }

    public URI getSchemaRegistryUri() {
        return this.schemaRegistryUri;
    }

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public CredentialProvider getCredentialProvider() {
        return this.credentialProvider;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public boolean isValidateHostName() {
        return this.validateHostName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaRegistryClientConfig)) {
            return false;
        }
        SchemaRegistryClientConfig other = (SchemaRegistryClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$schemaRegistryUri = this.getSchemaRegistryUri();
        URI other$schemaRegistryUri = other.getSchemaRegistryUri();
        if (this$schemaRegistryUri == null ? other$schemaRegistryUri != null : !((Object)this$schemaRegistryUri).equals(other$schemaRegistryUri)) {
            return false;
        }
        if (this.isAuthEnabled() != other.isAuthEnabled()) {
            return false;
        }
        CredentialProvider this$credentialProvider = this.getCredentialProvider();
        CredentialProvider other$credentialProvider = other.getCredentialProvider();
        if (this$credentialProvider == null ? other$credentialProvider != null : !this$credentialProvider.equals(other$credentialProvider)) {
            return false;
        }
        String this$trustStore = this.getTrustStore();
        String other$trustStore = other.getTrustStore();
        if (this$trustStore == null ? other$trustStore != null : !this$trustStore.equals(other$trustStore)) {
            return false;
        }
        String this$trustStoreType = this.getTrustStoreType();
        String other$trustStoreType = other.getTrustStoreType();
        if (this$trustStoreType == null ? other$trustStoreType != null : !this$trustStoreType.equals(other$trustStoreType)) {
            return false;
        }
        String this$trustStorePassword = this.getTrustStorePassword();
        String other$trustStorePassword = other.getTrustStorePassword();
        if (this$trustStorePassword == null ? other$trustStorePassword != null : !this$trustStorePassword.equals(other$trustStorePassword)) {
            return false;
        }
        String this$certificate = this.getCertificate();
        String other$certificate = other.getCertificate();
        if (this$certificate == null ? other$certificate != null : !this$certificate.equals(other$certificate)) {
            return false;
        }
        return this.isValidateHostName() == other.isValidateHostName();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaRegistryClientConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $schemaRegistryUri = this.getSchemaRegistryUri();
        result = result * 59 + ($schemaRegistryUri == null ? 43 : ((Object)$schemaRegistryUri).hashCode());
        result = result * 59 + (this.isAuthEnabled() ? 79 : 97);
        CredentialProvider $credentialProvider = this.getCredentialProvider();
        result = result * 59 + ($credentialProvider == null ? 43 : $credentialProvider.hashCode());
        String $trustStore = this.getTrustStore();
        result = result * 59 + ($trustStore == null ? 43 : $trustStore.hashCode());
        String $trustStoreType = this.getTrustStoreType();
        result = result * 59 + ($trustStoreType == null ? 43 : $trustStoreType.hashCode());
        String $trustStorePassword = this.getTrustStorePassword();
        result = result * 59 + ($trustStorePassword == null ? 43 : $trustStorePassword.hashCode());
        String $certificate = this.getCertificate();
        result = result * 59 + ($certificate == null ? 43 : $certificate.hashCode());
        result = result * 59 + (this.isValidateHostName() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SchemaRegistryClientConfig(schemaRegistryUri=" + this.getSchemaRegistryUri() + ", authEnabled=" + this.isAuthEnabled() + ", credentialProvider=" + this.getCredentialProvider() + ", trustStore=" + this.getTrustStore() + ", trustStoreType=" + this.getTrustStoreType() + ", trustStorePassword=" + this.getTrustStorePassword() + ", certificate=" + this.getCertificate() + ", validateHostName=" + this.isValidateHostName() + ")";
    }

    public static final class SchemaRegistryClientConfigBuilder {
        private URI schemaRegistryUri;
        private CredentialProvider credentialProvider;
        private boolean authEnabled = false;
        private boolean validateHostName = false;
        private String trustStore = null;
        private String trustStoreType = null;
        private String trustStorePassword = null;
        private String certificate = null;

        public SchemaRegistryClientConfigBuilder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public SchemaRegistryClientConfigBuilder trustStore(String trustStore, String trustStoreType, String trustStorePassword) {
            this.trustStore = trustStore;
            return this.trustStoreType(trustStoreType).trustStorePassword(trustStorePassword);
        }

        private SchemaRegistryClientConfigBuilder trustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
            return this;
        }

        private SchemaRegistryClientConfigBuilder trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public SchemaRegistryClientConfigBuilder authentication(String authMethod, String authToken) {
            return this.authEnabled().credentialProvider(new CredentialProvider.DefaultCredentialProvider(authMethod, authToken));
        }

        public SchemaRegistryClientConfigBuilder authentication(CredentialProvider credentialProvider) {
            return this.authEnabled().credentialProvider(credentialProvider);
        }

        private SchemaRegistryClientConfigBuilder authEnabled() {
            this.authEnabled = true;
            return this;
        }

        SchemaRegistryClientConfigBuilder() {
        }

        public SchemaRegistryClientConfigBuilder schemaRegistryUri(URI schemaRegistryUri) {
            this.schemaRegistryUri = schemaRegistryUri;
            return this;
        }

        public SchemaRegistryClientConfigBuilder credentialProvider(CredentialProvider credentialProvider) {
            this.credentialProvider = credentialProvider;
            return this;
        }

        public SchemaRegistryClientConfigBuilder validateHostName(boolean validateHostName) {
            this.validateHostName = validateHostName;
            return this;
        }

        public SchemaRegistryClientConfig build() {
            return new SchemaRegistryClientConfig(this.schemaRegistryUri, this.authEnabled, this.credentialProvider, this.trustStore, this.trustStoreType, this.trustStorePassword, this.certificate, this.validateHostName);
        }

        public String toString() {
            return "SchemaRegistryClientConfig.SchemaRegistryClientConfigBuilder(schemaRegistryUri=" + this.schemaRegistryUri + ", authEnabled=" + this.authEnabled + ", credentialProvider=" + this.credentialProvider + ", trustStore=" + this.trustStore + ", trustStoreType=" + this.trustStoreType + ", trustStorePassword=" + this.trustStorePassword + ", certificate=" + this.certificate + ", validateHostName=" + this.validateHostName + ")";
        }
    }
}

