/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.client.exceptions;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryExceptions
extends RuntimeException {
    private static final Logger log = LoggerFactory.getLogger(RegistryExceptions.class);

    public RegistryExceptions(String errorMessage) {
        super(errorMessage);
    }

    public static RegistryExceptions create(Type type, String errorMessage) {
        RegistryExceptions exception;
        Preconditions.checkArgument(errorMessage != null && !errorMessage.isEmpty(), "Either cause or errorMessage should be non-empty");
        switch (type) {
            case UNAUTHORIZED: {
                exception = new UnauthorizedException(errorMessage);
                break;
            }
            case BAD_ARGUMENT: {
                exception = new BadArgumentException(errorMessage);
                break;
            }
            case PRECONDITION_FAILED: {
                exception = new PreconditionFailedException(errorMessage);
                break;
            }
            case CODEC_NOT_FOUND: {
                exception = new CodecTypeNotRegisteredException(errorMessage);
                break;
            }
            case INCOMPATIBLE_SCHEMA: {
                exception = new SchemaValidationFailedException(errorMessage);
                break;
            }
            case RESOURCE_NOT_FOUND: {
                exception = new ResourceNotFoundException(errorMessage);
                break;
            }
            case SERIALIZATION_FORMAT_MISMATCH: {
                exception = new SerializationMismatchException(errorMessage);
                break;
            }
            case CONNECTION_ERROR: {
                exception = new ConnectionException(errorMessage);
                break;
            }
            case INTERNAL_SERVER_ERROR: {
                exception = new InternalServerError(errorMessage);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid exception type");
            }
        }
        return exception;
    }

    public static class InternalServerError
    extends RegistryExceptions
    implements RetryableException {
        public InternalServerError(String errorMessage) {
            super(errorMessage);
        }
    }

    public static class ConnectionException
    extends RegistryExceptions
    implements RetryableException {
        public ConnectionException(String errorMessage) {
            super(errorMessage);
        }
    }

    public static class SerializationMismatchException
    extends RegistryExceptions {
        public SerializationMismatchException(String errorMessage) {
            super(errorMessage);
        }
    }

    public static class ResourceNotFoundException
    extends RegistryExceptions {
        public ResourceNotFoundException(String errorMessage) {
            super(errorMessage);
        }
    }

    public static class SchemaValidationFailedException
    extends RegistryExceptions {
        public SchemaValidationFailedException(String errorMessage) {
            super(errorMessage);
        }
    }

    public static class MalformedSchemaException
    extends RegistryExceptions {
        public MalformedSchemaException(String errorMessage) {
            super(errorMessage);
        }
    }

    public static class CodecTypeNotRegisteredException
    extends RegistryExceptions {
        public CodecTypeNotRegisteredException(String errorMessage) {
            super(errorMessage);
        }
    }

    public static class PreconditionFailedException
    extends RegistryExceptions {
        public PreconditionFailedException(String errorMessage) {
            super(errorMessage);
        }
    }

    public static class BadArgumentException
    extends RegistryExceptions {
        public BadArgumentException(String errorMessage) {
            super(errorMessage);
        }
    }

    public static class UnauthorizedException
    extends RegistryExceptions {
        public UnauthorizedException(String errorMessage) {
            super(errorMessage);
        }
    }

    public static interface RetryableException {
    }

    public static enum Type {
        UNAUTHORIZED,
        BAD_ARGUMENT,
        PRECONDITION_FAILED,
        CODEC_NOT_FOUND,
        MALFORMED_SCHEMA,
        INCOMPATIBLE_SCHEMA,
        RESOURCE_NOT_FOUND,
        SERIALIZATION_FORMAT_MISMATCH,
        CONNECTION_ERROR,
        INTERNAL_SERVER_ERROR;

    }
}

