/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.common;

import com.google.common.base.Preconditions;
import io.pravega.common.util.ByteArraySegment;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class ChunkUtil {
    public static List<ByteArraySegment> chunk(@NonNull ByteBuffer byteBuffer, int maxChunkSize) {
        if (byteBuffer == null) {
            throw new NullPointerException("byteBuffer is marked @NonNull but is null");
        }
        Preconditions.checkArgument(maxChunkSize > 0, "MaxChunkSize should be greater than 0");
        int remaining = byteBuffer.remaining();
        int numberOfChunks = remaining != 0 && remaining % maxChunkSize == 0 ? remaining / maxChunkSize : remaining / maxChunkSize + 1;
        ArrayList<ByteArraySegment> chunks = new ArrayList<ByteArraySegment>();
        for (int i = 0; i < numberOfChunks; ++i) {
            int offset = byteBuffer.arrayOffset() + byteBuffer.position() + i * maxChunkSize;
            int length = Math.min(remaining - offset, maxChunkSize);
            ByteArraySegment chunk = new ByteArraySegment(byteBuffer.array(), offset, length);
            chunks.add(chunk);
        }
        return chunks;
    }

    public static ByteBuffer combine(List<ByteArraySegment> chunks) {
        ByteBuffer combined = ByteBuffer.allocate(chunks.stream().mapToInt(ByteArraySegment::getLength).reduce(0, Integer::sum));
        chunks.forEach(x -> combined.put(x.array(), x.arrayOffset(), x.getLength()));
        combined.rewind();
        return combined;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChunkUtil)) {
            return false;
        }
        ChunkUtil other = (ChunkUtil)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChunkUtil;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "ChunkUtil()";
    }
}

