/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.common;

import com.google.common.base.Preconditions;

public class Either<T, K> {
    private final T left;
    private final K right;

    private Either(T left, K right) {
        this.left = left;
        this.right = right;
    }

    public static <T, K> Either<T, K> left(T t) {
        Preconditions.checkNotNull(t);
        return new Either<T, Object>(t, null);
    }

    public static <T, K> Either<T, K> right(K k) {
        Preconditions.checkNotNull(k);
        return new Either<Object, K>(null, k);
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return this.right != null;
    }

    public T getLeft() {
        return this.left;
    }

    public K getRight() {
        return this.right;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Either)) {
            return false;
        }
        Either other = (Either)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$left = this.getLeft();
        T other$left = other.getLeft();
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
            return false;
        }
        K this$right = this.getRight();
        K other$right = other.getRight();
        return !(this$right == null ? other$right != null : !this$right.equals(other$right));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Either;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : $left.hashCode());
        K $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : $right.hashCode());
        return result;
    }

    public String toString() {
        return "Either(left=" + this.getLeft() + ", right=" + this.getRight() + ")";
    }
}

