/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class NameUtil {
    public static String extractName(String qualifiedName) {
        Preconditions.checkNotNull(qualifiedName, "Name cannot be null");
        return NameUtil.extractNameAndQualifier(qualifiedName)[0];
    }

    public static String[] extractNameAndQualifier(String qualifiedName) {
        Preconditions.checkNotNull(qualifiedName, "Name cannot be null");
        int nameStart = qualifiedName.lastIndexOf(".");
        String name = qualifiedName.substring(nameStart + 1);
        String pckg = nameStart < 0 ? "" : qualifiedName.substring(0, nameStart);
        return new String[]{name, pckg};
    }

    public static String qualifiedName(String qualifier, String name) {
        Preconditions.checkNotNull(name, "Name cannot be null");
        return Strings.isNullOrEmpty(qualifier) ? name : String.format("%s.%s", qualifier, name);
    }
}

