/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.data;

import com.google.common.base.Preconditions;
import io.pravega.common.ObjectBuilder;
import io.pravega.schemaregistry.contract.data.BackwardAndForward;
import io.pravega.schemaregistry.contract.data.VersionInfo;
import lombok.NonNull;

public class Compatibility {
    @NonNull
    private final Type type;
    private final BackwardAndForward backwardAndForward;

    private Compatibility(Type type) {
        this(type, null);
    }

    private Compatibility(@NonNull Type type, BackwardAndForward backwardAndForward) {
        if (type == null) {
            throw new NullPointerException("type is marked @NonNull but is null");
        }
        Preconditions.checkArgument(!type.equals((Object)Type.Advanced) || backwardAndForward != null, "For advanced type, At lease one of backward or forward policy should be supplied.");
        this.type = type;
        this.backwardAndForward = backwardAndForward;
    }

    public static Compatibility allowAny() {
        return new Compatibility(Type.AllowAny);
    }

    public static Compatibility denyAll() {
        return new Compatibility(Type.DenyAll);
    }

    public static Compatibility backward() {
        return new Compatibility(Type.Backward);
    }

    public static Compatibility backwardTill(VersionInfo backwardTill) {
        return Compatibility.backwardAndForward(new BackwardAndForward(new BackwardAndForward.BackwardTill(backwardTill), null));
    }

    public static Compatibility backwardTransitive() {
        return new Compatibility(Type.BackwardTransitive);
    }

    public static Compatibility forward() {
        return new Compatibility(Type.Forward);
    }

    public static Compatibility forwardTill(VersionInfo forwardTill) {
        return Compatibility.backwardAndForward(new BackwardAndForward(null, new BackwardAndForward.ForwardTill(forwardTill)));
    }

    public static Compatibility forwardTransitive() {
        return new Compatibility(Type.ForwardTransitive);
    }

    public static Compatibility full() {
        return new Compatibility(Type.Full);
    }

    public static Compatibility fullTransitive() {
        return new Compatibility(Type.FullTransitive);
    }

    public static Compatibility backwardTillAndForwardTill(VersionInfo backwardTill, VersionInfo forwardTill) {
        return Compatibility.backwardAndForward(new BackwardAndForward(new BackwardAndForward.BackwardTill(backwardTill), new BackwardAndForward.ForwardTill(forwardTill)));
    }

    public static Compatibility backwardOneAndForwardTill(VersionInfo forwardTill) {
        return Compatibility.backwardAndForward(new BackwardAndForward(BackwardAndForward.BACKWARD, new BackwardAndForward.ForwardTill(forwardTill)));
    }

    public static Compatibility backwardTillAndForwardOne(VersionInfo backwardTill) {
        return Compatibility.backwardAndForward(new BackwardAndForward(new BackwardAndForward.BackwardTill(backwardTill), BackwardAndForward.FORWARD));
    }

    private static Compatibility backwardAndForward(BackwardAndForward backwardAndForward) {
        return new Compatibility(Type.Advanced, backwardAndForward);
    }

    public static CompatibilityBuilder builder() {
        return new CompatibilityBuilder();
    }

    @NonNull
    public Type getType() {
        return this.type;
    }

    public BackwardAndForward getBackwardAndForward() {
        return this.backwardAndForward;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Compatibility)) {
            return false;
        }
        Compatibility other = (Compatibility)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        BackwardAndForward this$backwardAndForward = this.getBackwardAndForward();
        BackwardAndForward other$backwardAndForward = other.getBackwardAndForward();
        return !(this$backwardAndForward == null ? other$backwardAndForward != null : !((Object)this$backwardAndForward).equals(other$backwardAndForward));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Compatibility;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        BackwardAndForward $backwardAndForward = this.getBackwardAndForward();
        result = result * 59 + ($backwardAndForward == null ? 43 : ((Object)$backwardAndForward).hashCode());
        return result;
    }

    public String toString() {
        return "Compatibility(type=" + (Object)((Object)this.getType()) + ", backwardAndForward=" + this.getBackwardAndForward() + ")";
    }

    public static class CompatibilityBuilder
    implements ObjectBuilder<Compatibility> {
        private Type type;
        private BackwardAndForward backwardAndForward;

        CompatibilityBuilder() {
        }

        public CompatibilityBuilder type(@NonNull Type type) {
            if (type == null) {
                throw new NullPointerException("type is marked @NonNull but is null");
            }
            this.type = type;
            return this;
        }

        public CompatibilityBuilder backwardAndForward(BackwardAndForward backwardAndForward) {
            this.backwardAndForward = backwardAndForward;
            return this;
        }

        public Compatibility build() {
            return new Compatibility(this.type, this.backwardAndForward);
        }

        public String toString() {
            return "Compatibility.CompatibilityBuilder(type=" + (Object)((Object)this.type) + ", backwardAndForward=" + this.backwardAndForward + ")";
        }
    }

    public static enum Type {
        AllowAny,
        DenyAll,
        Backward,
        Forward,
        BackwardTransitive,
        ForwardTransitive,
        Full,
        FullTransitive,
        Advanced;

    }
}

