/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.pravega.common.ObjectBuilder;
import io.pravega.schemaregistry.contract.data.SerializationFormat;
import java.nio.ByteBuffer;
import lombok.NonNull;

public class SchemaInfo {
    public static final int ONE_MB = 0x100000;
    @NonNull
    private final String type;
    @NonNull
    private final SerializationFormat serializationFormat;
    @NonNull
    private final ByteBuffer schemaData;
    @NonNull
    private final ImmutableMap<String, String> properties;

    public SchemaInfo(@NonNull String type, @NonNull SerializationFormat serializationFormat, @NonNull ByteBuffer schemaData, @NonNull ImmutableMap<String, String> properties) {
        if (type == null) {
            throw new NullPointerException("type is marked @NonNull but is null");
        }
        if (serializationFormat == null) {
            throw new NullPointerException("serializationFormat is marked @NonNull but is null");
        }
        if (schemaData == null) {
            throw new NullPointerException("schemaData is marked @NonNull but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked @NonNull but is null");
        }
        Preconditions.checkArgument(serializationFormat != SerializationFormat.Any, "Invalid Serialization Format.");
        Preconditions.checkArgument(schemaData.remaining() <= 0x800000, "Invalid schema binary.");
        Preconditions.checkArgument(properties.size() <= 100 && properties.entrySet().stream().allMatch(x -> ((String)x.getKey()).length() <= 200 && ((String)x.getValue()).length() <= 200), "Invalid properties, make sure each key and value are less than or equal to 200 bytes and there are no more than 100 entries.");
        this.type = type;
        this.serializationFormat = serializationFormat;
        this.schemaData = schemaData;
        this.properties = properties;
    }

    public static SchemaInfoBuilder builder() {
        return new SchemaInfoBuilder();
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public SerializationFormat getSerializationFormat() {
        return this.serializationFormat;
    }

    @NonNull
    public ByteBuffer getSchemaData() {
        return this.schemaData;
    }

    @NonNull
    public ImmutableMap<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaInfo)) {
            return false;
        }
        SchemaInfo other = (SchemaInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        SerializationFormat this$serializationFormat = this.getSerializationFormat();
        SerializationFormat other$serializationFormat = other.getSerializationFormat();
        if (this$serializationFormat == null ? other$serializationFormat != null : !((Object)((Object)this$serializationFormat)).equals((Object)other$serializationFormat)) {
            return false;
        }
        ByteBuffer this$schemaData = this.getSchemaData();
        ByteBuffer other$schemaData = other.getSchemaData();
        if (this$schemaData == null ? other$schemaData != null : !((Object)this$schemaData).equals(other$schemaData)) {
            return false;
        }
        ImmutableMap<String, String> this$properties = this.getProperties();
        ImmutableMap<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        SerializationFormat $serializationFormat = this.getSerializationFormat();
        result = result * 59 + ($serializationFormat == null ? 43 : ((Object)((Object)$serializationFormat)).hashCode());
        ByteBuffer $schemaData = this.getSchemaData();
        result = result * 59 + ($schemaData == null ? 43 : ((Object)$schemaData).hashCode());
        ImmutableMap<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "SchemaInfo(type=" + this.getType() + ", serializationFormat=" + (Object)((Object)this.getSerializationFormat()) + ", schemaData=" + this.getSchemaData() + ", properties=" + this.getProperties() + ")";
    }

    public static class SchemaInfoBuilder
    implements ObjectBuilder<SchemaInfo> {
        private String type;
        private SerializationFormat serializationFormat;
        private ByteBuffer schemaData;
        private ImmutableMap<String, String> properties;

        SchemaInfoBuilder() {
        }

        public SchemaInfoBuilder type(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked @NonNull but is null");
            }
            this.type = type;
            return this;
        }

        public SchemaInfoBuilder serializationFormat(@NonNull SerializationFormat serializationFormat) {
            if (serializationFormat == null) {
                throw new NullPointerException("serializationFormat is marked @NonNull but is null");
            }
            this.serializationFormat = serializationFormat;
            return this;
        }

        public SchemaInfoBuilder schemaData(@NonNull ByteBuffer schemaData) {
            if (schemaData == null) {
                throw new NullPointerException("schemaData is marked @NonNull but is null");
            }
            this.schemaData = schemaData;
            return this;
        }

        public SchemaInfoBuilder properties(@NonNull ImmutableMap<String, String> properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked @NonNull but is null");
            }
            this.properties = properties;
            return this;
        }

        public SchemaInfo build() {
            return new SchemaInfo(this.type, this.serializationFormat, this.schemaData, this.properties);
        }

        public String toString() {
            return "SchemaInfo.SchemaInfoBuilder(type=" + this.type + ", serializationFormat=" + (Object)((Object)this.serializationFormat) + ", schemaData=" + this.schemaData + ", properties=" + this.properties + ")";
        }
    }
}

