/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.data;

import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.contract.data.VersionInfo;
import lombok.NonNull;

public class SchemaWithVersion {
    @NonNull
    private final SchemaInfo schemaInfo;
    @NonNull
    private final VersionInfo versionInfo;

    public static SchemaWithVersionBuilder builder() {
        return new SchemaWithVersionBuilder();
    }

    @NonNull
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    @NonNull
    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaWithVersion)) {
            return false;
        }
        SchemaWithVersion other = (SchemaWithVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SchemaInfo this$schemaInfo = this.getSchemaInfo();
        SchemaInfo other$schemaInfo = other.getSchemaInfo();
        if (this$schemaInfo == null ? other$schemaInfo != null : !((Object)this$schemaInfo).equals(other$schemaInfo)) {
            return false;
        }
        VersionInfo this$versionInfo = this.getVersionInfo();
        VersionInfo other$versionInfo = other.getVersionInfo();
        return !(this$versionInfo == null ? other$versionInfo != null : !((Object)this$versionInfo).equals(other$versionInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaWithVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SchemaInfo $schemaInfo = this.getSchemaInfo();
        result = result * 59 + ($schemaInfo == null ? 43 : ((Object)$schemaInfo).hashCode());
        VersionInfo $versionInfo = this.getVersionInfo();
        result = result * 59 + ($versionInfo == null ? 43 : ((Object)$versionInfo).hashCode());
        return result;
    }

    public String toString() {
        return "SchemaWithVersion(schemaInfo=" + this.getSchemaInfo() + ", versionInfo=" + this.getVersionInfo() + ")";
    }

    public SchemaWithVersion(@NonNull SchemaInfo schemaInfo, @NonNull VersionInfo versionInfo) {
        if (schemaInfo == null) {
            throw new NullPointerException("schemaInfo is marked @NonNull but is null");
        }
        if (versionInfo == null) {
            throw new NullPointerException("versionInfo is marked @NonNull but is null");
        }
        this.schemaInfo = schemaInfo;
        this.versionInfo = versionInfo;
    }

    public static class SchemaWithVersionBuilder {
        private SchemaInfo schemaInfo;
        private VersionInfo versionInfo;

        SchemaWithVersionBuilder() {
        }

        public SchemaWithVersionBuilder schemaInfo(@NonNull SchemaInfo schemaInfo) {
            if (schemaInfo == null) {
                throw new NullPointerException("schemaInfo is marked @NonNull but is null");
            }
            this.schemaInfo = schemaInfo;
            return this;
        }

        public SchemaWithVersionBuilder versionInfo(@NonNull VersionInfo versionInfo) {
            if (versionInfo == null) {
                throw new NullPointerException("versionInfo is marked @NonNull but is null");
            }
            this.versionInfo = versionInfo;
            return this;
        }

        public SchemaWithVersion build() {
            return new SchemaWithVersion(this.schemaInfo, this.versionInfo);
        }

        public String toString() {
            return "SchemaWithVersion.SchemaWithVersionBuilder(schemaInfo=" + this.schemaInfo + ", versionInfo=" + this.versionInfo + ")";
        }
    }
}

