/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.data;

import io.pravega.common.ObjectBuilder;
import lombok.NonNull;

public class VersionInfo {
    @NonNull
    private final String type;
    @NonNull
    private final String serializationFormatName;
    private final int version;
    private final int id;

    public static VersionInfoBuilder builder() {
        return new VersionInfoBuilder();
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public String getSerializationFormatName() {
        return this.serializationFormatName;
    }

    public int getVersion() {
        return this.version;
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionInfo)) {
            return false;
        }
        VersionInfo other = (VersionInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$serializationFormatName = this.getSerializationFormatName();
        String other$serializationFormatName = other.getSerializationFormatName();
        if (this$serializationFormatName == null ? other$serializationFormatName != null : !this$serializationFormatName.equals(other$serializationFormatName)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        return this.getId() == other.getId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof VersionInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $serializationFormatName = this.getSerializationFormatName();
        result = result * 59 + ($serializationFormatName == null ? 43 : $serializationFormatName.hashCode());
        result = result * 59 + this.getVersion();
        result = result * 59 + this.getId();
        return result;
    }

    public String toString() {
        return "VersionInfo(type=" + this.getType() + ", serializationFormatName=" + this.getSerializationFormatName() + ", version=" + this.getVersion() + ", id=" + this.getId() + ")";
    }

    public VersionInfo(@NonNull String type, @NonNull String serializationFormatName, int version, int id) {
        if (type == null) {
            throw new NullPointerException("type is marked @NonNull but is null");
        }
        if (serializationFormatName == null) {
            throw new NullPointerException("serializationFormatName is marked @NonNull but is null");
        }
        this.type = type;
        this.serializationFormatName = serializationFormatName;
        this.version = version;
        this.id = id;
    }

    public static class VersionInfoBuilder
    implements ObjectBuilder<VersionInfo> {
        private String type;
        private String serializationFormatName;
        private int version;
        private int id;

        VersionInfoBuilder() {
        }

        public VersionInfoBuilder type(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked @NonNull but is null");
            }
            this.type = type;
            return this;
        }

        public VersionInfoBuilder serializationFormatName(@NonNull String serializationFormatName) {
            if (serializationFormatName == null) {
                throw new NullPointerException("serializationFormatName is marked @NonNull but is null");
            }
            this.serializationFormatName = serializationFormatName;
            return this;
        }

        public VersionInfoBuilder version(int version) {
            this.version = version;
            return this;
        }

        public VersionInfoBuilder id(int id) {
            this.id = id;
            return this;
        }

        public VersionInfo build() {
            return new VersionInfo(this.type, this.serializationFormatName, this.version, this.id);
        }

        public String toString() {
            return "VersionInfo.VersionInfoBuilder(type=" + this.type + ", serializationFormatName=" + this.serializationFormatName + ", version=" + this.version + ", id=" + this.id + ")";
        }
    }
}

