/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.generated.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.pravega.schemaregistry.shaded.io.swagger.annotations.ApiModel;
import io.pravega.schemaregistry.shaded.io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;

@ApiModel(description="Codec Type.")
public class CodecType {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="properties")
    private Map<String, String> properties = null;

    public CodecType name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @ApiModelProperty(required=true, value="codecType name.")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CodecType properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public CodecType putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @JsonProperty(value="properties")
    @ApiModelProperty(value="User defined key value strings. Maximum size for the map, combined length of all keys and values should be less than or equal to 1 mb.")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodecType codecType = (CodecType)o;
        return Objects.equals(this.name, codecType.name) && Objects.equals(this.properties, codecType.properties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CodecType {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

