/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.generated.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.pravega.schemaregistry.contract.generated.rest.model.CodecType;
import io.pravega.schemaregistry.contract.generated.rest.model.SchemaInfo;
import io.pravega.schemaregistry.contract.generated.rest.model.VersionInfo;
import io.pravega.schemaregistry.shaded.io.swagger.annotations.ApiModel;
import io.pravega.schemaregistry.shaded.io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;

@ApiModel(description="Encoding information object that resolves the schema version and codec type used for corresponding encoding id.")
public class EncodingInfo {
    @JsonProperty(value="schemaInfo")
    private SchemaInfo schemaInfo = null;
    @JsonProperty(value="versionInfo")
    private VersionInfo versionInfo = null;
    @JsonProperty(value="codecType")
    private CodecType codecType = null;

    public EncodingInfo schemaInfo(SchemaInfo schemaInfo) {
        this.schemaInfo = schemaInfo;
        return this;
    }

    @JsonProperty(value="schemaInfo")
    @ApiModelProperty(required=true, value="Schema information object.")
    @NotNull
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public void setSchemaInfo(SchemaInfo schemaInfo) {
        this.schemaInfo = schemaInfo;
    }

    public EncodingInfo versionInfo(VersionInfo versionInfo) {
        this.versionInfo = versionInfo;
        return this;
    }

    @JsonProperty(value="versionInfo")
    @ApiModelProperty(required=true, value="Version information object.")
    @NotNull
    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public void setVersionInfo(VersionInfo versionInfo) {
        this.versionInfo = versionInfo;
    }

    public EncodingInfo codecType(CodecType codecType) {
        this.codecType = codecType;
        return this;
    }

    @JsonProperty(value="codecType")
    @ApiModelProperty(required=true, value="Codec type.")
    @NotNull
    public CodecType getCodecType() {
        return this.codecType;
    }

    public void setCodecType(CodecType codecType) {
        this.codecType = codecType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncodingInfo encodingInfo = (EncodingInfo)o;
        return Objects.equals(this.schemaInfo, encodingInfo.schemaInfo) && Objects.equals(this.versionInfo, encodingInfo.versionInfo) && Objects.equals(this.codecType, encodingInfo.codecType);
    }

    public int hashCode() {
        return Objects.hash(this.schemaInfo, this.versionInfo, this.codecType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EncodingInfo {\n");
        sb.append("    schemaInfo: ").append(this.toIndentedString(this.schemaInfo)).append("\n");
        sb.append("    versionInfo: ").append(this.toIndentedString(this.versionInfo)).append("\n");
        sb.append("    codecType: ").append(this.toIndentedString(this.codecType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

