/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.generated.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.pravega.schemaregistry.contract.generated.rest.model.Compatibility;
import io.pravega.schemaregistry.contract.generated.rest.model.SerializationFormat;
import io.pravega.schemaregistry.shaded.io.swagger.annotations.ApiModel;
import io.pravega.schemaregistry.shaded.io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;

@ApiModel(description="Metadata for a group.")
public class GroupProperties {
    @JsonProperty(value="serializationFormat")
    private SerializationFormat serializationFormat = null;
    @JsonProperty(value="compatibility")
    private Compatibility compatibility = null;
    @JsonProperty(value="allowMultipleTypes")
    private Boolean allowMultipleTypes = null;
    @JsonProperty(value="properties")
    private Map<String, String> properties = null;

    public GroupProperties serializationFormat(SerializationFormat serializationFormat) {
        this.serializationFormat = serializationFormat;
        return this;
    }

    @JsonProperty(value="serializationFormat")
    @ApiModelProperty(required=true, value="serialization format for the group.")
    @NotNull
    public SerializationFormat getSerializationFormat() {
        return this.serializationFormat;
    }

    public void setSerializationFormat(SerializationFormat serializationFormat) {
        this.serializationFormat = serializationFormat;
    }

    public GroupProperties compatibility(Compatibility compatibility) {
        this.compatibility = compatibility;
        return this;
    }

    @JsonProperty(value="compatibility")
    @ApiModelProperty(required=true, value="Compatibility to apply while registering new schema.")
    @NotNull
    public Compatibility getCompatibility() {
        return this.compatibility;
    }

    public void setCompatibility(Compatibility compatibility) {
        this.compatibility = compatibility;
    }

    public GroupProperties allowMultipleTypes(Boolean allowMultipleTypes) {
        this.allowMultipleTypes = allowMultipleTypes;
        return this;
    }

    @JsonProperty(value="allowMultipleTypes")
    @ApiModelProperty(required=true, value="Flag to indicate whether to allow multiple schemas representing distinct objects to be registered in the group.")
    @NotNull
    public Boolean isAllowMultipleTypes() {
        return this.allowMultipleTypes;
    }

    public void setAllowMultipleTypes(Boolean allowMultipleTypes) {
        this.allowMultipleTypes = allowMultipleTypes;
    }

    public GroupProperties properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public GroupProperties putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @JsonProperty(value="properties")
    @ApiModelProperty(value="User defined Key value strings.")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupProperties groupProperties = (GroupProperties)o;
        return Objects.equals(this.serializationFormat, groupProperties.serializationFormat) && Objects.equals(this.compatibility, groupProperties.compatibility) && Objects.equals(this.allowMultipleTypes, groupProperties.allowMultipleTypes) && Objects.equals(this.properties, groupProperties.properties);
    }

    public int hashCode() {
        return Objects.hash(this.serializationFormat, this.compatibility, this.allowMultipleTypes, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupProperties {\n");
        sb.append("    serializationFormat: ").append(this.toIndentedString(this.serializationFormat)).append("\n");
        sb.append("    compatibility: ").append(this.toIndentedString(this.compatibility)).append("\n");
        sb.append("    allowMultipleTypes: ").append(this.toIndentedString(this.allowMultipleTypes)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

