/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.generated.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.pravega.schemaregistry.contract.generated.rest.model.SerializationFormat;
import io.pravega.schemaregistry.shaded.io.swagger.annotations.ApiModel;
import io.pravega.schemaregistry.shaded.io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;

@ApiModel(description="Schema information object that encapsulates various properties of a schema.")
public class SchemaInfo {
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="serializationFormat")
    private SerializationFormat serializationFormat = null;
    @JsonProperty(value="schemaData")
    private byte[] schemaData = null;
    @JsonProperty(value="properties")
    private Map<String, String> properties = null;

    public SchemaInfo type(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @ApiModelProperty(required=true, value="Name of the schema. This identifies the type of object the schema payload represents.")
    @NotNull
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public SchemaInfo serializationFormat(SerializationFormat serializationFormat) {
        this.serializationFormat = serializationFormat;
        return this;
    }

    @JsonProperty(value="serializationFormat")
    @ApiModelProperty(required=true, value="Type of schema.")
    @NotNull
    public SerializationFormat getSerializationFormat() {
        return this.serializationFormat;
    }

    public void setSerializationFormat(SerializationFormat serializationFormat) {
        this.serializationFormat = serializationFormat;
    }

    public SchemaInfo schemaData(byte[] schemaData) {
        this.schemaData = schemaData;
        return this;
    }

    @JsonProperty(value="schemaData")
    @ApiModelProperty(required=true, value="Base64 encoded string for binary data for schema.")
    @NotNull
    public byte[] getSchemaData() {
        return this.schemaData;
    }

    public void setSchemaData(byte[] schemaData) {
        this.schemaData = schemaData;
    }

    public SchemaInfo properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public SchemaInfo putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @JsonProperty(value="properties")
    @ApiModelProperty(value="User defined key value strings.")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaInfo schemaInfo = (SchemaInfo)o;
        return Objects.equals(this.type, schemaInfo.type) && Objects.equals(this.serializationFormat, schemaInfo.serializationFormat) && Arrays.equals(this.schemaData, schemaInfo.schemaData) && Objects.equals(this.properties, schemaInfo.properties);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.serializationFormat, this.schemaData, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SchemaInfo {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    serializationFormat: ").append(this.toIndentedString(this.serializationFormat)).append("\n");
        sb.append("    schemaData: ").append(this.toIndentedString(this.schemaData)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

