/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.generated.rest.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.pravega.schemaregistry.shaded.io.swagger.annotations.ApiModel;
import io.pravega.schemaregistry.shaded.io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;

@ApiModel(description="Serialization format enum that lists different serialization formats supported by the service. To use additional formats, use serializationFormat.Custom and supply fullTypeName.")
public class SerializationFormat {
    @JsonProperty(value="serializationFormat")
    private SerializationFormatEnum serializationFormat = null;
    @JsonProperty(value="fullTypeName")
    private String fullTypeName = null;

    public SerializationFormat serializationFormat(SerializationFormatEnum serializationFormat) {
        this.serializationFormat = serializationFormat;
        return this;
    }

    @JsonProperty(value="serializationFormat")
    @ApiModelProperty(required=true, value="")
    @NotNull
    public SerializationFormatEnum getSerializationFormat() {
        return this.serializationFormat;
    }

    public void setSerializationFormat(SerializationFormatEnum serializationFormat) {
        this.serializationFormat = serializationFormat;
    }

    public SerializationFormat fullTypeName(String fullTypeName) {
        this.fullTypeName = fullTypeName;
        return this;
    }

    @JsonProperty(value="fullTypeName")
    @ApiModelProperty(value="")
    public String getFullTypeName() {
        return this.fullTypeName;
    }

    public void setFullTypeName(String fullTypeName) {
        this.fullTypeName = fullTypeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializationFormat serializationFormat = (SerializationFormat)o;
        return Objects.equals((Object)this.serializationFormat, (Object)serializationFormat.serializationFormat) && Objects.equals(this.fullTypeName, serializationFormat.fullTypeName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.serializationFormat, this.fullTypeName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SerializationFormat {\n");
        sb.append("    serializationFormat: ").append(this.toIndentedString((Object)this.serializationFormat)).append("\n");
        sb.append("    fullTypeName: ").append(this.toIndentedString(this.fullTypeName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SerializationFormatEnum {
        AVRO("Avro"),
        PROTOBUF("Protobuf"),
        JSON("Json"),
        ANY("Any"),
        CUSTOM("Custom");

        private String value;

        private SerializationFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SerializationFormatEnum fromValue(String text) {
            for (SerializationFormatEnum b : SerializationFormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

