/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.generated.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.pravega.schemaregistry.shaded.io.swagger.annotations.ApiModel;
import io.pravega.schemaregistry.shaded.io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;

@ApiModel(description="Version information object.")
public class VersionInfo {
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="serializationFormat")
    private String serializationFormat = null;
    @JsonProperty(value="version")
    private Integer version = null;
    @JsonProperty(value="id")
    private Integer id = null;

    public VersionInfo type(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @ApiModelProperty(required=true, value="Type of schema for this version. This is same value used in SchemaInfo#getType() for the schema this version identifies.")
    @NotNull
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public VersionInfo serializationFormat(String serializationFormat) {
        this.serializationFormat = serializationFormat;
        return this;
    }

    @JsonProperty(value="serializationFormat")
    @ApiModelProperty(required=true, value="Serialization format for the schema.")
    @NotNull
    public String getSerializationFormat() {
        return this.serializationFormat;
    }

    public void setSerializationFormat(String serializationFormat) {
        this.serializationFormat = serializationFormat;
    }

    public VersionInfo version(Integer version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="version")
    @ApiModelProperty(required=true, value="Version number that uniquely identifies the schema version among all schemas in the group that share the same Type.")
    @NotNull
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public VersionInfo id(Integer id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @ApiModelProperty(required=true, value="schema id that uniquely identifies schema version and describes the absolute order in which the schema was added to the group.")
    @NotNull
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionInfo versionInfo = (VersionInfo)o;
        return Objects.equals(this.type, versionInfo.type) && Objects.equals(this.version, versionInfo.version) && Objects.equals(this.id, versionInfo.id);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.version, this.id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VersionInfo {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

