/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.v1;

import com.google.common.annotations.Beta;
import io.pravega.schemaregistry.contract.generated.rest.model.AddedTo;
import io.pravega.schemaregistry.contract.generated.rest.model.CanRead;
import io.pravega.schemaregistry.contract.generated.rest.model.CodecType;
import io.pravega.schemaregistry.contract.generated.rest.model.CodecTypes;
import io.pravega.schemaregistry.contract.generated.rest.model.CreateGroupRequest;
import io.pravega.schemaregistry.contract.generated.rest.model.EncodingId;
import io.pravega.schemaregistry.contract.generated.rest.model.EncodingInfo;
import io.pravega.schemaregistry.contract.generated.rest.model.GetEncodingIdRequest;
import io.pravega.schemaregistry.contract.generated.rest.model.GroupHistory;
import io.pravega.schemaregistry.contract.generated.rest.model.GroupProperties;
import io.pravega.schemaregistry.contract.generated.rest.model.ListGroupsResponse;
import io.pravega.schemaregistry.contract.generated.rest.model.SchemaInfo;
import io.pravega.schemaregistry.contract.generated.rest.model.SchemaVersionsList;
import io.pravega.schemaregistry.contract.generated.rest.model.UpdateCompatibilityRequest;
import io.pravega.schemaregistry.contract.generated.rest.model.Valid;
import io.pravega.schemaregistry.contract.generated.rest.model.ValidateRequest;
import io.pravega.schemaregistry.contract.generated.rest.model.VersionInfo;
import io.pravega.schemaregistry.shaded.io.swagger.annotations.Api;
import io.pravega.schemaregistry.shaded.io.swagger.annotations.ApiOperation;
import io.pravega.schemaregistry.shaded.io.swagger.annotations.ApiParam;
import io.pravega.schemaregistry.shaded.io.swagger.annotations.ApiResponse;
import io.pravega.schemaregistry.shaded.io.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

public class ApiV1 {

    @Path(value="/v1/schemas")
    @Api(description="the schemas API")
    @Beta
    public static interface SchemasApiAsync {
        @POST
        @Path(value="/addedTo")
        @Consumes(value={"application/json"})
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Gets a map of groups to version info where the schema if it is registered. SchemaInfo#properties is ignored while comparing the schema.", response=AddedTo.class, tags={"Schema"})
        @ApiResponses(value={@ApiResponse(code=200, message="Schema version", response=AddedTo.class), @ApiResponse(code=404, message="Schema not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while fetching Schema references", response=Void.class)})
        public void getSchemaReferences(@ApiParam(value="Get schema references for the supplied schema", required=true) SchemaInfo var1, @ApiParam(value="namespace") @QueryParam(value="namespace") String var2, @Context SecurityContext var3, @Suspended AsyncResponse var4);
    }

    @Path(value="/v1/schemas")
    @Api(description="the schemas API")
    @Beta
    public static interface SchemasApi {
        @POST
        @Path(value="/addedTo")
        @Consumes(value={"application/json"})
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Gets a map of groups to version info where the schema if it is registered. SchemaInfo#properties is ignored while comparing the schema.", response=AddedTo.class, tags={"Schema"})
        @ApiResponses(value={@ApiResponse(code=200, message="Schema version", response=AddedTo.class), @ApiResponse(code=404, message="Schema not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while fetching Schema references", response=Void.class)})
        public Response getSchemaReferences(@ApiParam(value="Get schema references for the supplied schema", required=true) SchemaInfo var1, @ApiParam(value="namespace") @QueryParam(value="namespace") String var2);
    }

    @Path(value="/v1/groups")
    @Api(description="the groups API")
    @Beta
    public static interface GroupsApiAsync {
        @POST
        @Path(value="/{groupName}/codecTypes")
        @Consumes(value={"application/json"})
        @ApiOperation(value="", notes="Adds a new codecType to the group.", response=Void.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=201, message="Successfully added codecType to group", response=Void.class), @ApiResponse(code=404, message="Group not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while registering codectype to a Group", response=Void.class)})
        public void addCodecType(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="The codec type", required=true) CodecType var3, @Context SecurityContext var4, @Suspended AsyncResponse var5);

        @POST
        @Path(value="/{groupName}/schemas")
        @Consumes(value={"application/json"})
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Adds a new schema to the group", response=VersionInfo.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=201, message="Successfully added schema to the group", response=VersionInfo.class), @ApiResponse(code=404, message="Group not found", response=Void.class), @ApiResponse(code=409, message="Incompatible schema", response=Void.class), @ApiResponse(code=417, message="Invalid serialization format", response=Void.class), @ApiResponse(code=500, message="Internal server error while adding a schema", response=Void.class)})
        public void addSchema(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Add new schema to group", required=true) SchemaInfo var3, @Context SecurityContext var4, @Suspended AsyncResponse var5);

        @POST
        @Path(value="/{groupName}/schemas/versions/canRead")
        @Consumes(value={"application/json"})
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Checks if given schema can be used for reads subject to compatibility policy in the compatibility.", response=CanRead.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Response to tell whether schema can be used to read existing schemas", response=CanRead.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while checking schema for readability", response=Void.class)})
        public void canRead(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Checks if schema can be used to read the data in the stream based on compatibility policy.", required=true) SchemaInfo var3, @Context SecurityContext var4, @Suspended AsyncResponse var5);

        @POST
        @Consumes(value={"application/json"})
        @ApiOperation(value="", notes="Create a new Group", response=Void.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=201, message="Successfully added group", response=Void.class), @ApiResponse(code=409, message="Group with given name already exists", response=Void.class), @ApiResponse(code=500, message="Internal server error while creating a Group", response=Void.class)})
        public void createGroup(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="The Group configuration", required=true) CreateGroupRequest var2, @Context SecurityContext var3, @Suspended AsyncResponse var4);

        @DELETE
        @Path(value="/{groupName}")
        @ApiOperation(value="", notes="Delete a Group", response=Void.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=204, message="Successfully deleted the Group", response=Void.class), @ApiResponse(code=500, message="Internal server error while deleting the Group", response=Void.class)})
        public void deleteGroup(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @Context SecurityContext var3, @Suspended AsyncResponse var4);

        @GET
        @Path(value="/{groupName}/codecTypes")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Get codecTypes for the group.", response=CodecTypes.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Found CodecTypes", response=CodecTypes.class), @ApiResponse(code=404, message="Group or encoding id with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while fetching codecTypes registered", response=Void.class)})
        public void getCodecTypesList(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @Context SecurityContext var3, @Suspended AsyncResponse var4);

        @GET
        @Path(value="/{groupName}/encodings/{encodingId}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Get the encoding information corresponding to the encoding id.", response=EncodingInfo.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Found Encoding", response=EncodingInfo.class), @ApiResponse(code=404, message="Group or encoding id with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while getting encoding info corresponding to encoding id", response=Void.class)})
        public void getEncodingInfo(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Encoding id that identifies a unique combination of schema and codecType", required=true) @PathParam(value="encodingId") Integer var3, @Context SecurityContext var4, @Suspended AsyncResponse var5);

        @GET
        @Path(value="/{groupName}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Fetch the properties of an existing Group", response=GroupProperties.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Found Group properties", response=GroupProperties.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while fetching Group details", response=Void.class)})
        public void getGroupProperties(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @Context SecurityContext var3, @Suspended AsyncResponse var4);

        @GET
        @Path(value="/{groupName}/history")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Fetch the history of schema evolution of a Group", response=GroupHistory.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Found Group history", response=GroupHistory.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while fetching Group history", response=Void.class)})
        public void getGroupHistory(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @Context SecurityContext var3, @Suspended AsyncResponse var4);

        @GET
        @Path(value="/{groupName}/schemas/versions")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Get all schema versions for the group.", response=SchemaVersionsList.class, tags={"Schema"})
        @ApiResponses(value={@ApiResponse(code=200, message="Versioned history of schemas registered under the group", response=SchemaVersionsList.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while fetching Group details", response=Void.class)})
        public void getSchemaVersions(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Type") @QueryParam(value="type") String var3, @Context SecurityContext var4, @Suspended AsyncResponse var5);

        @GET
        @Path(value="/{groupName}/schemas")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Fetch latest schema versions for all objects identified by SchemaInfo#getType() under a Group. If query param type is specified then latest schema for the type is returned.", response=SchemaVersionsList.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Latest schemas for all objects identified by SchemaInfo#getType() under the group", response=SchemaVersionsList.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while fetching Group's latest schemas", response=Void.class)})
        public void getSchemas(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Type of object") @QueryParam(value="type") String var3, @Context SecurityContext var4, @Suspended AsyncResponse var5);

        @PUT
        @Path(value="/{groupName}/encodings")
        @Consumes(value={"application/json"})
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Get an encoding id that uniquely identifies a schema version and codec type pair.", response=EncodingId.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Found Encoding", response=EncodingId.class), @ApiResponse(code=404, message="Group with given name or version not found", response=Void.class), @ApiResponse(code=412, message="Codec type not registered", response=Void.class), @ApiResponse(code=500, message="Internal server error while getting encoding id", response=Void.class)})
        public void getEncodingId(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Get schema corresponding to the version", required=true) GetEncodingIdRequest var3, @Context SecurityContext var4, @Suspended AsyncResponse var5);

        @GET
        @Path(value="/{groupName}/schemas/schema/{schemaId}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Get schema from the version id that uniquely identifies the schema in the group.", response=SchemaInfo.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Schema corresponding to the version", response=SchemaInfo.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while fetching schema from version", response=Void.class)})
        public void getSchemaForId(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="version id", required=true) @PathParam(value="schemaId") Integer var3, @Context SecurityContext var4, @Suspended AsyncResponse var5);

        @DELETE
        @Path(value="/{groupName}/schemas/schema/{schemaId}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Delete schema version from the group.", response=Void.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=204, message="Schema corresponding to the version", response=Void.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while deleting schema from group", response=Void.class)})
        public void deleteSchemaForId(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="version id", required=true) @PathParam(value="schemaId") Integer var3, @Context SecurityContext var4, @Suspended AsyncResponse var5);

        @GET
        @Path(value="/{groupName}/schemas/format/{serializationFormat}/type/{type}/versions/{version}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Get schema from the version id that uniquely identifies the schema in the group.", response=SchemaInfo.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Schema corresponding to the version", response=SchemaInfo.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while fetching schema from version", response=Void.class)})
        public void getSchemaFromVersion(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Serialization format", required=true) @PathParam(value="serializationFormat") String var3, @ApiParam(value="Schema type from SchemaInfo#getType() or VersionInfo#type", required=true) @PathParam(value="type") String var4, @ApiParam(value="Version number", required=true) @PathParam(value="version") Integer var5, @Context SecurityContext var6, @Suspended AsyncResponse var7);

        @DELETE
        @Path(value="/{groupName}/schemas/format/{serializationFormat}/type/{type}/versions/{version}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Delete schema version from the group.", response=Void.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=204, message="Schema corresponding to the version", response=Void.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while deleting schema from group", response=Void.class)})
        public void deleteSchemaVersion(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Serialization format", required=true) @PathParam(value="serializationFormat") String var3, @ApiParam(value="Schema type from SchemaInfo#getType() or VersionInfo#type", required=true) @PathParam(value="type") String var4, @ApiParam(value="Version number", required=true) @PathParam(value="version") Integer var5, @Context SecurityContext var6, @Suspended AsyncResponse var7);

        @POST
        @Path(value="/{groupName}/schemas/versions/find")
        @Consumes(value={"application/json"})
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Get the version for the schema if it is registered.", response=VersionInfo.class, tags={"Schema"})
        @ApiResponses(value={@ApiResponse(code=200, message="Schema version", response=VersionInfo.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while fetching Group details", response=Void.class)})
        public void getSchemaVersion(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Get schema corresponding to the version", required=true) SchemaInfo var3, @Context SecurityContext var4, @Suspended AsyncResponse var5);

        @GET
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="List all groups", response=ListGroupsResponse.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="List of all groups", response=ListGroupsResponse.class), @ApiResponse(code=500, message="Internal server error while fetching the list of Groups", response=Void.class)})
        public void listGroups(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Continuation token") @QueryParam(value="continuationToken") String var2, @ApiParam(value="The numbers of items to return") @QueryParam(value="limit") Integer var3, @Context SecurityContext var4, @Suspended AsyncResponse var5);

        @PUT
        @Path(value="/{groupName}/compatibility")
        @Consumes(value={"application/json"})
        @ApiOperation(value="", notes="update compatibility of an existing Group", response=Void.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Updated schema compatibility policy", response=Void.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=409, message="Write conflict", response=Void.class), @ApiResponse(code=500, message="Internal server error while updating Group's compatibility", response=Void.class)})
        public void updateCompatibility(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="update group policy", required=true) UpdateCompatibilityRequest var3, @Context SecurityContext var4, @Suspended AsyncResponse var5);

        @POST
        @Path(value="/{groupName}/schemas/versions/validate")
        @Consumes(value={"application/json"})
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Checks if given schema is compatible with schemas in the registry for current policy setting.", response=Valid.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Schema validation response", response=Valid.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while trying to validate schema", response=Void.class)})
        public void validate(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Checks if schema is valid with respect to supplied compatibility", required=true) ValidateRequest var3, @Context SecurityContext var4, @Suspended AsyncResponse var5);
    }

    @Path(value="/v1/groups")
    @Api(description="the groups API")
    @Beta
    public static interface GroupsApi {
        @POST
        @Path(value="/{groupName}/codecTypes")
        @Consumes(value={"application/json"})
        @ApiOperation(value="", notes="Adds a new codecType to the group.", response=Void.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=201, message="Successfully added codecType to group", response=Void.class), @ApiResponse(code=404, message="Group not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while creating a Group", response=Void.class)})
        public Response addCodecType(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="The codec type", required=true) CodecType var3);

        @POST
        @Path(value="/{groupName}/schemas")
        @Consumes(value={"application/json"})
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Adds a new schema to the group", response=VersionInfo.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=201, message="Successfully added schema to the group", response=VersionInfo.class), @ApiResponse(code=404, message="Group not found", response=Void.class), @ApiResponse(code=409, message="Incompatible schema", response=Void.class), @ApiResponse(code=417, message="Invalid serialization format", response=Void.class), @ApiResponse(code=500, message="Internal server error while creating a Group", response=Void.class)})
        public Response addSchema(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Add new schema to group", required=true) SchemaInfo var3);

        @POST
        @Path(value="/{groupName}/schemas/versions/canRead")
        @Consumes(value={"application/json"})
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Checks if given schema can be used for reads subject to compatibility policy in the compatibility.", response=CanRead.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Response to tell whether schema can be used to read existing schemas", response=CanRead.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while checking schema for readability", response=Void.class)})
        public Response canRead(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Checks if schema can be used to read the data in the stream based on compatibility policy.", required=true) SchemaInfo var3);

        @POST
        @Consumes(value={"application/json"})
        @ApiOperation(value="", notes="Create a new Group", response=Void.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=201, message="Successfully added group", response=Void.class), @ApiResponse(code=409, message="Group with given name already exists", response=Void.class), @ApiResponse(code=500, message="Internal server error while creating a Group", response=Void.class)})
        public Response createGroup(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="The Group configuration", required=true) CreateGroupRequest var2);

        @DELETE
        @Path(value="/{groupName}")
        @ApiOperation(value="", notes="Delete a Group", response=Void.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=204, message="Successfully deleted the Group", response=Void.class), @ApiResponse(code=500, message="Internal server error while deleting the Group", response=Void.class)})
        public Response deleteGroup(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2);

        @GET
        @Path(value="/{groupName}/codecTypes")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Get codecTypes for the group.", response=CodecTypes.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Found CodecTypes", response=CodecTypes.class), @ApiResponse(code=404, message="Group or encoding id with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while fetching codecTypes registered", response=Void.class)})
        public Response getCodecTypesList(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2);

        @GET
        @Path(value="/{groupName}/encodings/{encodingId}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Get the encoding information corresponding to the encoding id.", response=EncodingInfo.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Found Encoding", response=EncodingInfo.class), @ApiResponse(code=404, message="Group or encoding id with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while getting encoding info corresponding to encoding id", response=Void.class)})
        public Response getEncodingInfo(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Encoding id that identifies a unique combination of schema and codecType", required=true) @PathParam(value="encodingId") Integer var3);

        @GET
        @Path(value="/{groupName}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Fetch the properties of an existing Group", response=GroupProperties.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Found Group properties", response=GroupProperties.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while fetching Group details", response=Void.class)})
        public Response getGroupProperties(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2);

        @GET
        @Path(value="/{groupName}/history")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Fetch the history of schema evolution of a Group", response=GroupHistory.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Found Group history", response=GroupHistory.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while fetching Group history", response=Void.class)})
        public Response getGroupHistory(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2);

        @GET
        @Path(value="/{groupName}/schemas/versions")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Get all schema versions for the group", response=SchemaVersionsList.class, tags={"Schema"})
        @ApiResponses(value={@ApiResponse(code=200, message="Versioned history of schemas registered under the group", response=SchemaVersionsList.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while fetching Group details", response=Void.class)})
        public Response getSchemaVersions(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Type") @QueryParam(value="type") String var3);

        @GET
        @Path(value="/{groupName}/schemas")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Fetch latest schema versions for all objects identified by SchemaInfo#getType() under a Group. If query param type is specified then latest schema for the type is returned.", response=SchemaVersionsList.class, tags={"Schema"})
        @ApiResponses(value={@ApiResponse(code=200, message="Latest schemas for all objects identified by SchemaInfo#getType() under the group", response=SchemaVersionsList.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while fetching Group details", response=Void.class)})
        public Response getSchemas(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Type of object") @QueryParam(value="type") String var3);

        @PUT
        @Path(value="/{groupName}/encodings")
        @Consumes(value={"application/json"})
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Get an encoding id that uniquely identifies a schema version and codec type pair.", response=EncodingId.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Found Encoding", response=EncodingId.class), @ApiResponse(code=404, message="Group with given name or version not found", response=Void.class), @ApiResponse(code=412, message="Codec type not registered", response=Void.class), @ApiResponse(code=500, message="Internal server error while getting encoding id", response=Void.class)})
        public Response getEncodingId(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Get schema corresponding to the version", required=true) GetEncodingIdRequest var3);

        @DELETE
        @Path(value="/{groupName}/schemas/schema/{schemaId}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Delete schema version from the group.", response=Void.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=204, message="Schema corresponding to the version deleted", response=Void.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while deleting schema from group", response=Void.class)})
        public Response deleteSchemaForId(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="version id", required=true) @PathParam(value="schemaId") Integer var3);

        @GET
        @Path(value="/{groupName}/schemas/schema/{schemaId}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Get schema from the version id that uniquely identifies the schema in the group.", response=SchemaInfo.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Schema corresponding to the version", response=SchemaInfo.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while fetching schema from version", response=Void.class)})
        public Response getSchemaForId(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="version id", required=true) @PathParam(value="schemaId") Integer var3);

        @GET
        @Path(value="/{groupName}/schemas/format/{serializationFormat}/type/{type}/versions/{version}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Get schema from the version id that uniquely identifies the schema in the group.", response=SchemaInfo.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Schema corresponding to the version", response=SchemaInfo.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while fetching schema from version", response=Void.class)})
        public Response getSchemaFromVersion(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Serialization format", required=true) @PathParam(value="format") String var3, @ApiParam(value="Schema type from SchemaInfo#getType() or VersionInfo#type", required=true) @PathParam(value="type") String var4, @ApiParam(value="Version number", required=true) @PathParam(value="version") Integer var5);

        @DELETE
        @Path(value="/{groupName}/schemas/format/{serializationFormat}/type/{type}/versions/{version}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Delete schema version from the group.", response=Void.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=204, message="Schema corresponding to the version", response=Void.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while deleting schema from group", response=Void.class)})
        public Response deleteSchemaVersion(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Serialization format", required=true) @PathParam(value="format") String var3, @ApiParam(value="Schema type from SchemaInfo#getType() or VersionInfo#type", required=true) @PathParam(value="type") String var4, @ApiParam(value="Version number", required=true) @PathParam(value="version") Integer var5);

        @POST
        @Path(value="/{groupName}/schemas/versions/find")
        @Consumes(value={"application/json"})
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Get the version for the schema if it is registered.", response=VersionInfo.class, tags={"Schema"})
        @ApiResponses(value={@ApiResponse(code=200, message="Schema version", response=VersionInfo.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while fetching Group details", response=Void.class)})
        public Response getSchemaVersion(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Get schema corresponding to the version", required=true) SchemaInfo var3);

        @GET
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="List all groups", response=ListGroupsResponse.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="List of all groups", response=ListGroupsResponse.class), @ApiResponse(code=500, message="Internal server error while fetching the list of Groups", response=Void.class)})
        public Response listGroups(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Continuation token") @QueryParam(value="continuationToken") String var2, @ApiParam(value="The numbers of items to return") @QueryParam(value="limit") Integer var3);

        @PUT
        @Path(value="/{groupName}/compatibility")
        @Consumes(value={"application/json"})
        @ApiOperation(value="", notes="update compatibility of an existing Group", response=Void.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Updated schema compatibility policy", response=Void.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=409, message="Write conflict", response=Void.class), @ApiResponse(code=500, message="Internal server error while updating Group's compatibility", response=Void.class)})
        public Response updateCompatibility(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="update group policy", required=true) UpdateCompatibilityRequest var3);

        @POST
        @Path(value="/{groupName}/schemas/versions/validate")
        @Consumes(value={"application/json"})
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Checks if given schema is compatible with schemas in the registry for current policy setting.", response=Valid.class, tags={"Group"})
        @ApiResponses(value={@ApiResponse(code=200, message="Schema validation response", response=Valid.class), @ApiResponse(code=404, message="Group with given name not found", response=Void.class), @ApiResponse(code=500, message="Internal server error while trying to validate schema", response=Void.class)})
        public Response validate(@ApiParam(value="namespace") @QueryParam(value="namespace") String var1, @ApiParam(value="Group name", required=true) @PathParam(value="groupName") String var2, @ApiParam(value="Checks if schema is valid with respect to supplied compatibility", required=true) ValidateRequest var3);
    }

    @Path(value="/ping")
    public static interface Ping {
        @GET
        public Response ping();
    }
}

