/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.avro.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.serializer.avro.schemas.AvroSchema;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.EncodingCache;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecordBase;

class AvroDeserializer<T>
extends AbstractDeserializer<T> {
    private final ConcurrentHashMap<ByteBuffer, DatumReader<T>> knownSchemaReaders;
    private final boolean specific;
    private final Schema readerSchema;

    AvroDeserializer(String groupId, SchemaRegistryClient client, AvroSchema<T> schema, SerializerConfig.Decoders decoder, EncodingCache encodingCache) {
        super(groupId, client, schema, false, decoder, encodingCache, true);
        Preconditions.checkNotNull(schema);
        this.knownSchemaReaders = new ConcurrentHashMap();
        this.specific = SpecificRecordBase.class.isAssignableFrom(schema.getTClass());
        this.readerSchema = schema.getSchema();
        ByteBuffer schemaData = schema.getSchemaInfo().getSchemaData();
        this.knownSchemaReaders.put(schemaData, this.createDatumReader(this.readerSchema, this.readerSchema, this.specific));
    }

    @Override
    public final T deserialize(InputStream inputStream, SchemaInfo writerSchemaInfo, SchemaInfo readerSchemaInfo) throws IOException {
        Preconditions.checkNotNull(writerSchemaInfo);
        ByteBuffer writerSchemaData = writerSchemaInfo.getSchemaData();
        DatumReader datumReader = this.knownSchemaReaders.computeIfAbsent(writerSchemaData, key -> {
            Schema writerSchema = AvroSchema.from(writerSchemaInfo).getSchema();
            return this.createDatumReader(writerSchema, this.readerSchema, this.specific);
        });
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(inputStream, null);
        return datumReader.read(null, decoder);
    }

    @VisibleForTesting
    DatumReader<T> createDatumReader(Schema writerSchema, Schema readerSchema, boolean specific) {
        SpecificDatumReader datumReader = specific ? new SpecificDatumReader(writerSchema, readerSchema) : new ReflectDatumReader(writerSchema, readerSchema);
        return datumReader;
    }

    @VisibleForTesting
    ImmutableMap<ByteBuffer, DatumReader<T>> getKnownSchemaReaders() {
        return ImmutableMap.copyOf(this.knownSchemaReaders);
    }
}

