/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.avro.impl;

import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.serializer.avro.schemas.AvroSchema;
import io.pravega.schemaregistry.serializer.shared.codec.Encoder;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractSerializer;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;

public class AvroSerializer<T>
extends AbstractSerializer<T> {
    private final SpecificDatumWriter<T> specificDatumWriter;
    private final GenericDatumWriter<T> genericDatumWriter;
    private final ReflectDatumWriter<T> reflectDatumWriter;

    public AvroSerializer(String groupId, SchemaRegistryClient client, AvroSchema<T> schema, Encoder encoder, boolean registerSchema) {
        super(groupId, client, schema, encoder, registerSchema, true);
        Schema avroSchema = schema.getSchema();
        this.specificDatumWriter = new SpecificDatumWriter(avroSchema);
        this.genericDatumWriter = new GenericDatumWriter(avroSchema);
        this.reflectDatumWriter = new ReflectDatumWriter(avroSchema);
    }

    @Override
    protected void serialize(T var, SchemaInfo schemaInfo, OutputStream outputStream) throws IOException {
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(outputStream, null);
        if (SpecificRecord.class.isAssignableFrom(var.getClass())) {
            this.specificDatumWriter.write(var, encoder);
        } else if (IndexedRecord.class.isAssignableFrom(var.getClass())) {
            this.genericDatumWriter.write(var, encoder);
        } else {
            this.reflectDatumWriter.write(var, encoder);
        }
        encoder.flush();
        outputStream.flush();
    }
}

