/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.avro.impl;

import com.google.common.base.Preconditions;
import io.pravega.client.stream.Serializer;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.common.Either;
import io.pravega.schemaregistry.serializer.avro.impl.AvroDeserializer;
import io.pravega.schemaregistry.serializer.avro.impl.AvroGenericDeserializer;
import io.pravega.schemaregistry.serializer.avro.impl.AvroSerializer;
import io.pravega.schemaregistry.serializer.avro.schemas.AvroSchema;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractSerializer;
import io.pravega.schemaregistry.serializer.shared.impl.EncodingCache;
import io.pravega.schemaregistry.serializer.shared.impl.MultiplexedAndGenericDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.MultiplexedDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.MultiplexedSerializer;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerConfig;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerFactoryHelper;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSerializerFactory {
    private static final Logger log = LoggerFactory.getLogger(AvroSerializerFactory.class);

    public static <T> Serializer<T> serializer(@NonNull SerializerConfig config, @NonNull AvroSchema<T> schema) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked @NonNull but is null");
        }
        Preconditions.checkArgument(config.isWriteEncodingHeader(), "Events should be tagged with encoding ids.");
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForSerializer(config);
        String groupId = config.getGroupId();
        return new AvroSerializer<T>(groupId, schemaRegistryClient, schema, config.getEncoder(), config.isRegisterSchema());
    }

    public static <T> Serializer<T> deserializer(@NonNull SerializerConfig config, @NonNull AvroSchema<T> schema) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked @NonNull but is null");
        }
        Preconditions.checkArgument(config.isWriteEncodingHeader(), "Events should be tagged with encoding ids.");
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForDeserializer(config);
        String groupId = config.getGroupId();
        EncodingCache encodingCache = new EncodingCache(groupId, schemaRegistryClient);
        return new AvroDeserializer<T>(groupId, schemaRegistryClient, schema, config.getDecoders(), encodingCache);
    }

    public static Serializer<Object> genericDeserializer(@NonNull SerializerConfig config, @Nullable AvroSchema<Object> schema) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        Preconditions.checkArgument(config.isWriteEncodingHeader(), "Events should be tagged with encoding ids.");
        String groupId = config.getGroupId();
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForDeserializer(config);
        EncodingCache encodingCache = new EncodingCache(groupId, schemaRegistryClient);
        return new AvroGenericDeserializer(groupId, schemaRegistryClient, schema, config.getDecoders(), encodingCache);
    }

    public static <T> Serializer<T> multiTypeSerializer(@NonNull SerializerConfig config, @NonNull Map<Class<? extends T>, AvroSchema<T>> schemas) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (schemas == null) {
            throw new NullPointerException("schemas is marked @NonNull but is null");
        }
        Preconditions.checkArgument(config.isWriteEncodingHeader(), "Events should be tagged with encoding ids.");
        String groupId = config.getGroupId();
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForSerializer(config);
        Map serializerMap = AvroSerializerFactory.getSerializerMap(config, schemas, groupId, schemaRegistryClient);
        return new MultiplexedSerializer(serializerMap);
    }

    private static <T> Map<Class<? extends T>, AbstractSerializer<T>> getSerializerMap(SerializerConfig config, Map<Class<? extends T>, AvroSchema<T>> schemas, String groupId, SchemaRegistryClient schemaRegistryClient) {
        return schemas.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> new AvroSerializer(groupId, schemaRegistryClient, (AvroSchema)x.getValue(), config.getEncoder(), config.isRegisterSchema())));
    }

    public static <T> Serializer<T> multiTypeDeserializer(@NonNull SerializerConfig config, @NonNull Map<Class<? extends T>, AvroSchema<T>> schemas) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (schemas == null) {
            throw new NullPointerException("schemas is marked @NonNull but is null");
        }
        Preconditions.checkArgument(config.isWriteEncodingHeader(), "Events should be tagged with encoding ids.");
        String groupId = config.getGroupId();
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForDeserializer(config);
        EncodingCache encodingCache = new EncodingCache(groupId, schemaRegistryClient);
        Map deserializerMap = AvroSerializerFactory.getDeserializerMap(config, schemas, groupId, schemaRegistryClient, encodingCache);
        return new MultiplexedDeserializer(groupId, schemaRegistryClient, deserializerMap, config.getDecoders(), encodingCache);
    }

    private static <T> Map<String, AbstractDeserializer<T>> getDeserializerMap(SerializerConfig config, Map<Class<? extends T>, AvroSchema<T>> schemas, String groupId, SchemaRegistryClient schemaRegistryClient, EncodingCache encodingCache) {
        return schemas.values().stream().collect(Collectors.toMap(x -> x.getSchemaInfo().getType(), x -> new AvroDeserializer(groupId, schemaRegistryClient, x, config.getDecoders(), encodingCache)));
    }

    public static <T> Serializer<Either<T, Object>> typedOrGenericDeserializer(@NonNull SerializerConfig config, @NonNull Map<Class<? extends T>, AvroSchema<T>> schemas) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (schemas == null) {
            throw new NullPointerException("schemas is marked @NonNull but is null");
        }
        Preconditions.checkArgument(config.isWriteEncodingHeader(), "Events should be tagged with encoding ids.");
        String groupId = config.getGroupId();
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForDeserializer(config);
        EncodingCache encodingCache = new EncodingCache(groupId, schemaRegistryClient);
        Map deserializerMap = AvroSerializerFactory.getDeserializerMap(config, schemas, groupId, schemaRegistryClient, encodingCache);
        AvroGenericDeserializer genericDeserializer = new AvroGenericDeserializer(groupId, schemaRegistryClient, null, config.getDecoders(), encodingCache);
        return new MultiplexedAndGenericDeserializer(groupId, schemaRegistryClient, deserializerMap, genericDeserializer, config.getDecoders(), encodingCache);
    }
}

