/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.avro.schemas;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.contract.data.SerializationFormat;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecordBase;

public class AvroSchema<T>
implements io.pravega.schemaregistry.serializer.shared.schemas.Schema<T> {
    private final Schema schema;
    private final SchemaInfo schemaInfo;
    private final Class<T> tClass;

    private AvroSchema(Schema schema, Class<T> tClass) {
        this.schema = schema;
        this.schemaInfo = new SchemaInfo(schema.getFullName(), SerializationFormat.Avro, this.getSchemaBytes(), ImmutableMap.of());
        this.tClass = tClass;
    }

    private AvroSchema(SchemaInfo schemaInfo) {
        String schemaString = new String(schemaInfo.getSchemaData().array(), Charsets.UTF_8);
        this.schema = new Schema.Parser().parse(schemaString);
        this.schemaInfo = schemaInfo;
        this.tClass = null;
    }

    public static <T> AvroSchema<T> of(Class<T> tClass) {
        Schema schema = SpecificRecordBase.class.isAssignableFrom(tClass) ? SpecificData.get().getSchema(tClass) : ReflectData.get().getSchema(tClass);
        return new AvroSchema<T>(schema, tClass);
    }

    public static AvroSchema<Object> of(Schema schema) {
        return new AvroSchema<Object>(schema, Object.class);
    }

    public static AvroSchema<GenericRecord> ofRecord(Schema schema) {
        Preconditions.checkArgument(schema.getType().equals((Object)Schema.Type.RECORD));
        return new AvroSchema<GenericRecord>(schema, GenericRecord.class);
    }

    public static <T> AvroSchema<T> ofBaseType(Class<? extends T> tDerived, Class<T> tBase) {
        Preconditions.checkArgument(tBase.isAssignableFrom(tDerived));
        return new AvroSchema<T>(ReflectData.get().getSchema(tDerived), tBase);
    }

    public static <T extends SpecificRecordBase> AvroSchema<SpecificRecordBase> ofSpecificRecord(Class<T> tClass) {
        Preconditions.checkArgument(SpecificRecordBase.class.isAssignableFrom(tClass));
        return new AvroSchema<SpecificRecordBase>(SpecificData.get().getSchema(tClass), SpecificRecordBase.class);
    }

    public static AvroSchema<Object> from(SchemaInfo schemaInfo) {
        return new AvroSchema<Object>(schemaInfo);
    }

    private ByteBuffer getSchemaBytes() {
        return ByteBuffer.wrap(this.schema.toString().getBytes(Charsets.UTF_8));
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public Class<T> getTClass() {
        return this.tClass;
    }
}

