/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.json.impl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.serializer.json.schemas.JSONSchema;
import io.pravega.schemaregistry.serializer.shared.codec.Encoder;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractSerializer;
import java.io.IOException;
import java.io.OutputStream;

public class JsonSerializer<T>
extends AbstractSerializer<T> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonSerializer(String groupId, SchemaRegistryClient client, JSONSchema<T> schema, Encoder encoder, boolean registerSchema, boolean encodeHeader) {
        super(groupId, client, schema, encoder, registerSchema, encodeHeader);
        this.objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
    }

    @Override
    protected void serialize(T var, SchemaInfo schemaInfo, OutputStream outputStream) throws IOException {
        this.objectMapper.writeValue(outputStream, var);
        outputStream.flush();
    }
}

