/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.json.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import io.pravega.client.stream.Serializer;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.common.Either;
import io.pravega.schemaregistry.serializer.json.impl.JsonDeserializer;
import io.pravega.schemaregistry.serializer.json.impl.JsonGenericDeserializer;
import io.pravega.schemaregistry.serializer.json.impl.JsonSerializer;
import io.pravega.schemaregistry.serializer.json.impl.JsonStringDeserializer;
import io.pravega.schemaregistry.serializer.json.schemas.JSONSchema;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractSerializer;
import io.pravega.schemaregistry.serializer.shared.impl.EncodingCache;
import io.pravega.schemaregistry.serializer.shared.impl.MultiplexedAndGenericDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.MultiplexedDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.MultiplexedSerializer;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerConfig;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerFactoryHelper;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializerFactory {
    private static final Logger log = LoggerFactory.getLogger(JsonSerializerFactory.class);

    public static <T> Serializer<T> serializer(@NonNull SerializerConfig config, @NonNull JSONSchema<T> schema) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked @NonNull but is null");
        }
        String groupId = config.getGroupId();
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForSerializer(config);
        return new JsonSerializer<T>(groupId, schemaRegistryClient, schema, config.getEncoder(), config.isRegisterSchema(), config.isWriteEncodingHeader());
    }

    public static <T> Serializer<T> deserializer(@NonNull SerializerConfig config, @NonNull JSONSchema<T> schema) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked @NonNull but is null");
        }
        String groupId = config.getGroupId();
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForDeserializer(config);
        EncodingCache encodingCache = new EncodingCache(groupId, schemaRegistryClient);
        return new JsonDeserializer<T>(groupId, schemaRegistryClient, schema, config.getDecoders(), encodingCache, config.isWriteEncodingHeader());
    }

    public static Serializer<JsonNode> genericDeserializer(@NonNull SerializerConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForDeserializer(config);
        String groupId = config.getGroupId();
        EncodingCache encodingCache = new EncodingCache(groupId, schemaRegistryClient);
        return new JsonGenericDeserializer(groupId, schemaRegistryClient, config.getDecoders(), encodingCache, config.isWriteEncodingHeader());
    }

    public static Serializer<String> deserializeAsString(@NonNull SerializerConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForDeserializer(config);
        String groupId = config.getGroupId();
        EncodingCache encodingCache = new EncodingCache(groupId, schemaRegistryClient);
        return new JsonStringDeserializer(groupId, schemaRegistryClient, config.getDecoders(), encodingCache, config.isWriteEncodingHeader());
    }

    public static <T> Serializer<T> multiTypeSerializer(@NonNull SerializerConfig config, @NonNull Map<Class<? extends T>, JSONSchema<T>> schemas) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (schemas == null) {
            throw new NullPointerException("schemas is marked @NonNull but is null");
        }
        Preconditions.checkArgument(config.isWriteEncodingHeader(), "Events should be tagged with encoding ids.");
        String groupId = config.getGroupId();
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForSerializer(config);
        Map serializerMap = JsonSerializerFactory.getSerializerMap(config, schemas, groupId, schemaRegistryClient);
        return new MultiplexedSerializer(serializerMap);
    }

    private static <T> Map<Class<? extends T>, AbstractSerializer<T>> getSerializerMap(SerializerConfig config, Map<Class<? extends T>, JSONSchema<T>> schemas, String groupId, SchemaRegistryClient schemaRegistryClient) {
        return schemas.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> new JsonSerializer(groupId, schemaRegistryClient, (JSONSchema)x.getValue(), config.getEncoder(), config.isRegisterSchema(), config.isWriteEncodingHeader())));
    }

    public static <T> Serializer<T> multiTypeDeserializer(@NonNull SerializerConfig config, @NonNull Map<Class<? extends T>, JSONSchema<T>> schemas) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (schemas == null) {
            throw new NullPointerException("schemas is marked @NonNull but is null");
        }
        Preconditions.checkArgument(config.isWriteEncodingHeader(), "Events should be tagged with encoding ids.");
        String groupId = config.getGroupId();
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForDeserializer(config);
        EncodingCache encodingCache = new EncodingCache(groupId, schemaRegistryClient);
        Map deserializerMap = JsonSerializerFactory.getDeserializerMap(config, schemas, groupId, schemaRegistryClient, encodingCache);
        return new MultiplexedDeserializer(groupId, schemaRegistryClient, deserializerMap, config.getDecoders(), encodingCache);
    }

    private static <T> Map<String, AbstractDeserializer<T>> getDeserializerMap(SerializerConfig config, Map<Class<? extends T>, JSONSchema<T>> schemas, String groupId, SchemaRegistryClient schemaRegistryClient, EncodingCache encodingCache) {
        return schemas.values().stream().collect(Collectors.toMap(x -> x.getSchemaInfo().getType(), x -> new JsonDeserializer(groupId, schemaRegistryClient, x, config.getDecoders(), encodingCache, config.isWriteEncodingHeader())));
    }

    public static <T> Serializer<Either<T, JsonNode>> typedOrGenericDeserializer(@NonNull SerializerConfig config, @NonNull Map<Class<? extends T>, JSONSchema<T>> schemas) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (schemas == null) {
            throw new NullPointerException("schemas is marked @NonNull but is null");
        }
        Preconditions.checkArgument(config.isWriteEncodingHeader(), "Events should be tagged with encoding ids.");
        String groupId = config.getGroupId();
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForDeserializer(config);
        EncodingCache encodingCache = new EncodingCache(groupId, schemaRegistryClient);
        Map deserializerMap = JsonSerializerFactory.getDeserializerMap(config, schemas, groupId, schemaRegistryClient, encodingCache);
        JsonGenericDeserializer genericDeserializer = new JsonGenericDeserializer(groupId, schemaRegistryClient, config.getDecoders(), encodingCache, config.isWriteEncodingHeader());
        return new MultiplexedAndGenericDeserializer(groupId, schemaRegistryClient, deserializerMap, genericDeserializer, config.getDecoders(), encodingCache);
    }
}

