/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.json.schemas;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.contract.data.SerializationFormat;
import io.pravega.schemaregistry.serializer.shared.schemas.Schema;
import java.nio.ByteBuffer;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.SpecificationVersion;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONSchema<T>
implements Schema<T> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final String schemaString;
    private final Class<T> base;
    private final Class<? extends T> derived;
    private final org.everit.json.schema.Schema schema;
    private final SchemaInfo schemaInfo;

    private JSONSchema(String name, String schemaString, Class<T> derived) {
        this(name, schemaString, derived, derived);
    }

    private JSONSchema(String name, String schemaString, Class<T> base, Class<? extends T> derived) {
        this.schemaString = schemaString;
        this.schemaInfo = new SchemaInfo(name, SerializationFormat.Json, this.getSchemaBytes(), ImmutableMap.of());
        this.base = base;
        this.derived = derived;
        this.schema = JSONSchema.getSchemaObj(schemaString);
    }

    private JSONSchema(SchemaInfo schemaInfo, String schemaString, Class<T> derived) {
        this.schemaString = schemaString;
        this.schemaInfo = schemaInfo;
        this.base = derived;
        this.derived = derived;
        this.schema = JSONSchema.getSchemaObj(schemaString);
    }

    public static <T> JSONSchema<T> of(Class<T> tClass) {
        Preconditions.checkNotNull(tClass);
        try {
            JsonSchemaGenerator schemaGen = new JsonSchemaGenerator(OBJECT_MAPPER);
            JsonSchema schema = schemaGen.generateSchema(tClass);
            String schemaString = OBJECT_MAPPER.writeValueAsString(schema);
            return new JSONSchema<T>(tClass.getName(), schemaString, tClass);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to get json schema from the class", e);
        }
    }

    public static <T> JSONSchema<T> of(String type, JsonSchema schema, Class<T> tClass) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(schema);
        try {
            String schemaString = OBJECT_MAPPER.writeValueAsString(schema);
            return new JSONSchema<T>(type, schemaString, tClass);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to get json schema string from the JsonSchema object", e);
        }
    }

    public static <T> JSONSchema<T> of(String type, String schemaString, Class<T> tClass) {
        Preconditions.checkNotNull(type, "Type cannot be null.");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(schemaString), "Schema String cannot be null or empty.");
        return new JSONSchema<T>(type, schemaString, tClass);
    }

    public static <T> JSONSchema<T> ofBaseType(Class<? extends T> tDerived, Class<T> tBase) {
        Preconditions.checkNotNull(tDerived);
        Preconditions.checkNotNull(tBase);
        try {
            JsonSchemaGenerator schemaGen = new JsonSchemaGenerator(OBJECT_MAPPER);
            JsonSchema jsonSchema = schemaGen.generateSchema(tDerived);
            String schemaString = OBJECT_MAPPER.writeValueAsString(jsonSchema);
            return new JSONSchema<T>(tDerived.getName(), schemaString, tBase, tDerived);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to get json schema from the class", e);
        }
    }

    public static JSONSchema<JsonNode> from(SchemaInfo schemaInfo) {
        Preconditions.checkNotNull(schemaInfo);
        String schemaString = new String(schemaInfo.getSchemaData().array(), Charsets.UTF_8);
        return new JSONSchema<JsonNode>(schemaInfo, schemaString, JsonNode.class);
    }

    private static org.everit.json.schema.Schema getSchemaObj(String schemaString) {
        JSONObject rawSchema = new JSONObject(new JSONTokener(schemaString));
        if (rawSchema.has(SpecificationVersion.DRAFT_4.idKeyword())) {
            return SchemaLoader.builder().useDefaults(true).schemaJson(rawSchema).build().load().build();
        }
        return SchemaLoader.builder().useDefaults(true).schemaJson(rawSchema).draftV7Support().build().load().build();
    }

    private ByteBuffer getSchemaBytes() {
        return ByteBuffer.wrap(this.schemaString.getBytes(Charsets.UTF_8));
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    @Override
    public Class<T> getTClass() {
        return this.base;
    }

    public String getSchemaString() {
        return this.schemaString;
    }

    public Class<? extends T> getDerived() {
        return this.derived;
    }

    public org.everit.json.schema.Schema getSchema() {
        return this.schema;
    }
}

