/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.protobuf.impl;

import com.google.common.base.Preconditions;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import io.pravega.client.stream.Serializer;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.common.Either;
import io.pravega.schemaregistry.serializer.protobuf.impl.ProtobufDeserializer;
import io.pravega.schemaregistry.serializer.protobuf.impl.ProtobufGenericDeserializer;
import io.pravega.schemaregistry.serializer.protobuf.impl.ProtobufSerializer;
import io.pravega.schemaregistry.serializer.protobuf.schemas.ProtobufSchema;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractSerializer;
import io.pravega.schemaregistry.serializer.shared.impl.EncodingCache;
import io.pravega.schemaregistry.serializer.shared.impl.MultiplexedAndGenericDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.MultiplexedDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.MultiplexedSerializer;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerConfig;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerFactoryHelper;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufSerializerFactory {
    private static final Logger log = LoggerFactory.getLogger(ProtobufSerializerFactory.class);

    public static <T extends Message> Serializer<T> serializer(@NonNull SerializerConfig config, @NonNull ProtobufSchema<T> schema) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked @NonNull but is null");
        }
        String groupId = config.getGroupId();
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForSerializer(config);
        return new ProtobufSerializer<T>(groupId, schemaRegistryClient, schema, config.getEncoder(), config.isRegisterSchema(), config.isWriteEncodingHeader());
    }

    public static <T extends GeneratedMessageV3> Serializer<T> deserializer(@NonNull SerializerConfig config, @NonNull ProtobufSchema<T> schema) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked @NonNull but is null");
        }
        String groupId = config.getGroupId();
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForDeserializer(config);
        EncodingCache encodingCache = new EncodingCache(groupId, schemaRegistryClient);
        return new ProtobufDeserializer<T>(groupId, schemaRegistryClient, schema, config.getDecoders(), encodingCache, config.isWriteEncodingHeader());
    }

    public static Serializer<DynamicMessage> genericDeserializer(@NonNull SerializerConfig config, @Nullable ProtobufSchema<DynamicMessage> schema) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        Preconditions.checkArgument(schema != null || config.isWriteEncodingHeader(), "Either read schema should be supplied or events should be tagged with encoding ids.");
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForDeserializer(config);
        String groupId = config.getGroupId();
        EncodingCache encodingCache = new EncodingCache(groupId, schemaRegistryClient);
        return new ProtobufGenericDeserializer(groupId, schemaRegistryClient, schema, config.getDecoders(), encodingCache, config.isWriteEncodingHeader());
    }

    public static <T extends GeneratedMessageV3> Serializer<T> multiTypeSerializer(@NonNull SerializerConfig config, @NonNull Map<Class<? extends T>, ProtobufSchema<T>> schemas) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (schemas == null) {
            throw new NullPointerException("schemas is marked @NonNull but is null");
        }
        Preconditions.checkArgument(config.isWriteEncodingHeader(), "Events should be tagged with encoding ids.");
        String groupId = config.getGroupId();
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForSerializer(config);
        Map serializerMap = ProtobufSerializerFactory.getSerializerMap(config, schemas, groupId, schemaRegistryClient);
        return new MultiplexedSerializer(serializerMap);
    }

    private static <T extends GeneratedMessageV3> Map<Class<? extends T>, AbstractSerializer<T>> getSerializerMap(SerializerConfig config, Map<Class<? extends T>, ProtobufSchema<T>> schemas, String groupId, SchemaRegistryClient schemaRegistryClient) {
        return schemas.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> new ProtobufSerializer(groupId, schemaRegistryClient, (ProtobufSchema)x.getValue(), config.getEncoder(), config.isRegisterSchema(), config.isWriteEncodingHeader())));
    }

    public static <T extends GeneratedMessageV3> Serializer<T> multiTypeDeserializer(@NonNull SerializerConfig config, @NonNull Map<Class<? extends T>, ProtobufSchema<T>> schemas) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (schemas == null) {
            throw new NullPointerException("schemas is marked @NonNull but is null");
        }
        Preconditions.checkArgument(config.isWriteEncodingHeader(), "Events should be tagged with encoding ids.");
        String groupId = config.getGroupId();
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForDeserializer(config);
        EncodingCache encodingCache = new EncodingCache(groupId, schemaRegistryClient);
        Map deserializerMap = ProtobufSerializerFactory.getDeserializerMap(config, schemas, groupId, schemaRegistryClient, encodingCache);
        return new MultiplexedDeserializer(groupId, schemaRegistryClient, deserializerMap, config.getDecoders(), encodingCache);
    }

    public static <T extends GeneratedMessageV3> Serializer<Either<T, DynamicMessage>> typedOrGenericDeserializer(@NonNull SerializerConfig config, @NonNull Map<Class<? extends T>, ProtobufSchema<T>> schemas) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (schemas == null) {
            throw new NullPointerException("schemas is marked @NonNull but is null");
        }
        Preconditions.checkArgument(config.isWriteEncodingHeader(), "Events should be tagged with encoding ids.");
        String groupId = config.getGroupId();
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForDeserializer(config);
        EncodingCache encodingCache = new EncodingCache(groupId, schemaRegistryClient);
        Map deserializerMap = ProtobufSerializerFactory.getDeserializerMap(config, schemas, groupId, schemaRegistryClient, encodingCache);
        ProtobufGenericDeserializer genericDeserializer = new ProtobufGenericDeserializer(groupId, schemaRegistryClient, null, config.getDecoders(), encodingCache, config.isWriteEncodingHeader());
        return new MultiplexedAndGenericDeserializer(groupId, schemaRegistryClient, deserializerMap, genericDeserializer, config.getDecoders(), encodingCache);
    }

    private static <T extends GeneratedMessageV3> Map<String, AbstractDeserializer<T>> getDeserializerMap(SerializerConfig config, Map<Class<? extends T>, ProtobufSchema<T>> schemas, String groupId, SchemaRegistryClient schemaRegistryClient, EncodingCache encodingCache) {
        return schemas.values().stream().collect(Collectors.toMap(x -> x.getSchemaInfo().getType(), x -> new ProtobufDeserializer(groupId, schemaRegistryClient, x, config.getDecoders(), encodingCache, config.isWriteEncodingHeader())));
    }
}

