/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializers;

import com.google.common.base.Preconditions;
import io.pravega.client.stream.Serializer;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.contract.data.SerializationFormat;
import io.pravega.schemaregistry.serializer.avro.impl.AvroGenericDeserializer;
import io.pravega.schemaregistry.serializer.avro.impl.AvroSerializer;
import io.pravega.schemaregistry.serializer.avro.schemas.AvroSchema;
import io.pravega.schemaregistry.serializer.json.impl.JsonGenericDeserializer;
import io.pravega.schemaregistry.serializer.json.impl.JsonSerializer;
import io.pravega.schemaregistry.serializer.json.schemas.JSONSchema;
import io.pravega.schemaregistry.serializer.protobuf.impl.ProtobufGenericDeserializer;
import io.pravega.schemaregistry.serializer.protobuf.impl.ProtobufSerializer;
import io.pravega.schemaregistry.serializer.protobuf.schemas.ProtobufSchema;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractSerializer;
import io.pravega.schemaregistry.serializer.shared.impl.CustomDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.CustomSerializer;
import io.pravega.schemaregistry.serializer.shared.impl.EncodingCache;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerConfig;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerFactoryHelper;
import io.pravega.schemaregistry.serializer.shared.schemas.Schema;
import io.pravega.schemaregistry.serializers.MultiFormatWithSchemaDeserializer;
import io.pravega.schemaregistry.serializers.MultipleFormatDeserializer;
import io.pravega.schemaregistry.serializers.MultipleFormatSerializer;
import io.pravega.schemaregistry.serializers.WithSchema;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MultiFormatSerializerFactory {
    private static final Logger log = LoggerFactory.getLogger(MultiFormatSerializerFactory.class);

    MultiFormatSerializerFactory() {
    }

    static Serializer<WithSchema<Object>> serializer(@NonNull SerializerConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        Preconditions.checkArgument(config.isWriteEncodingHeader(), "Events should be tagged with encoding ids.");
        return MultiFormatSerializerFactory.serializerInternal(config, Collections.emptyMap());
    }

    static Serializer<WithSchema<Object>> deserializerWithSchema(@NonNull SerializerConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        Preconditions.checkArgument(config.isWriteEncodingHeader(), "Events should be tagged with encoding ids.");
        return MultiFormatSerializerFactory.deserializerInternal(config, Collections.emptyMap(), WithSchema.NO_TRANSFORM);
    }

    static <T> Serializer<T> deserializeAsT(@NonNull SerializerConfig config, @NonNull BiFunction<SerializationFormat, Object, T> transform) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (transform == null) {
            throw new NullPointerException("transform is marked @NonNull but is null");
        }
        Preconditions.checkArgument(config.isWriteEncodingHeader(), "Events should be tagged with encoding ids.");
        return MultiFormatSerializerFactory.deserializeAsTInternal(config, Collections.emptyMap(), transform);
    }

    private static Serializer<WithSchema<Object>> serializerInternal(@NonNull SerializerConfig config, @NonNull Map<SerializationFormat, CustomSerializer<Object>> customSerializers) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (customSerializers == null) {
            throw new NullPointerException("customSerializers is marked @NonNull but is null");
        }
        Preconditions.checkArgument(config.isWriteEncodingHeader(), "Events should be tagged with encoding ids.");
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForSerializer(config);
        String groupId = config.getGroupId();
        Function<SchemaInfo, AbstractSerializer<Object>> serializerFunction = x -> MultiFormatSerializerFactory.getPravegaSerializer(config, customSerializers, schemaRegistryClient, groupId, x);
        return new MultipleFormatSerializer(serializerFunction);
    }

    private static <T> Serializer<T> deserializeAsTInternal(SerializerConfig config, Map<SerializationFormat, CustomDeserializer<Object>> deserializers, BiFunction<SerializationFormat, Object, T> transform) {
        String groupId = config.getGroupId();
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForDeserializer(config);
        EncodingCache encodingCache = new EncodingCache(groupId, schemaRegistryClient);
        JsonGenericDeserializer json = new JsonGenericDeserializer(config.getGroupId(), schemaRegistryClient, config.getDecoders(), encodingCache, config.isWriteEncodingHeader());
        ProtobufGenericDeserializer protobuf = new ProtobufGenericDeserializer(groupId, schemaRegistryClient, null, config.getDecoders(), encodingCache, config.isWriteEncodingHeader());
        AvroGenericDeserializer avro = new AvroGenericDeserializer(groupId, schemaRegistryClient, null, config.getDecoders(), encodingCache);
        HashMap<SerializationFormat, AbstractDeserializer> map = new HashMap<SerializationFormat, AbstractDeserializer>();
        map.put(SerializationFormat.Json, json);
        map.put(SerializationFormat.Avro, avro);
        map.put(SerializationFormat.Protobuf, protobuf);
        deserializers.forEach((key, value) -> map.put((SerializationFormat)((Object)key), new AbstractDeserializer<Object>(groupId, schemaRegistryClient, null, false, config.getDecoders(), encodingCache, config.isWriteEncodingHeader()){

            @Override
            public final Object deserialize(InputStream inputStream, SchemaInfo writerSchema, SchemaInfo readerSchema) {
                return value.deserialize(inputStream, writerSchema, readerSchema);
            }
        }));
        return new MultipleFormatDeserializer<T>(groupId, schemaRegistryClient, map, config.getDecoders(), encodingCache, transform);
    }

    private static <T> Serializer<WithSchema<T>> deserializerInternal(SerializerConfig config, Map<SerializationFormat, CustomDeserializer<Object>> deserializers, BiFunction<SerializationFormat, Object, T> transform) {
        String groupId = config.getGroupId();
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForDeserializer(config);
        EncodingCache encodingCache = new EncodingCache(groupId, schemaRegistryClient);
        JsonGenericDeserializer json = new JsonGenericDeserializer(config.getGroupId(), schemaRegistryClient, config.getDecoders(), encodingCache, config.isWriteEncodingHeader());
        ProtobufGenericDeserializer protobuf = new ProtobufGenericDeserializer(groupId, schemaRegistryClient, null, config.getDecoders(), encodingCache, config.isWriteEncodingHeader());
        AvroGenericDeserializer avro = new AvroGenericDeserializer(groupId, schemaRegistryClient, null, config.getDecoders(), encodingCache);
        HashMap<SerializationFormat, AbstractDeserializer> map = new HashMap<SerializationFormat, AbstractDeserializer>();
        map.put(SerializationFormat.Json, json);
        map.put(SerializationFormat.Avro, avro);
        map.put(SerializationFormat.Protobuf, protobuf);
        deserializers.forEach((key, value) -> map.put((SerializationFormat)((Object)key), new AbstractDeserializer<Object>(groupId, schemaRegistryClient, null, false, config.getDecoders(), encodingCache, config.isWriteEncodingHeader()){

            @Override
            public final Object deserialize(InputStream inputStream, SchemaInfo writerSchema, SchemaInfo readerSchema) {
                return value.deserialize(inputStream, writerSchema, readerSchema);
            }
        }));
        return new MultiFormatWithSchemaDeserializer<T>(groupId, schemaRegistryClient, map, config.getDecoders(), encodingCache, transform);
    }

    private static AbstractSerializer<Object> getPravegaSerializer(SerializerConfig config, Map<SerializationFormat, CustomSerializer<Object>> customSerializers, SchemaRegistryClient schemaRegistryClient, String groupId, SchemaInfo schemaInfo) {
        switch (schemaInfo.getSerializationFormat()) {
            case Avro: {
                return new AvroSerializer<Object>(groupId, schemaRegistryClient, AvroSchema.from(schemaInfo), config.getEncoder(), config.isRegisterSchema());
            }
            case Protobuf: {
                ProtobufSerializer<Object> pSerializer = new ProtobufSerializer<Object>(groupId, schemaRegistryClient, ProtobufSchema.from(schemaInfo), config.getEncoder(), config.isRegisterSchema(), config.isWriteEncodingHeader());
                return pSerializer;
            }
            case Json: {
                JsonSerializer<Object> jsonSerializer = new JsonSerializer<Object>(groupId, schemaRegistryClient, JSONSchema.from(schemaInfo), config.getEncoder(), config.isRegisterSchema(), config.isWriteEncodingHeader());
                return jsonSerializer;
            }
            case Custom: {
                return MultiFormatSerializerFactory.getCustomSerializer(config, customSerializers, schemaRegistryClient, groupId, schemaInfo);
            }
        }
        throw new IllegalArgumentException("Serializer not provided");
    }

    private static AbstractSerializer<Object> getCustomSerializer(SerializerConfig config, Map<SerializationFormat, CustomSerializer<Object>> customSerializers, SchemaRegistryClient schemaRegistryClient, String groupId, final SchemaInfo schemaInfo) {
        if (customSerializers.containsKey((Object)schemaInfo.getSerializationFormat())) {
            final CustomSerializer<Object> serializer = customSerializers.get((Object)schemaInfo.getSerializationFormat());
            Schema<Object> schema = new Schema<Object>(){

                @Override
                public SchemaInfo getSchemaInfo() {
                    return schemaInfo;
                }

                @Override
                public Class<Object> getTClass() {
                    return Object.class;
                }
            };
            return new AbstractSerializer<Object>(groupId, schemaRegistryClient, (Schema)schema, config.getEncoder(), config.isRegisterSchema(), config.isWriteEncodingHeader()){

                @Override
                protected void serialize(Object var, SchemaInfo schema, OutputStream outputStream) {
                    serializer.serialize(var, schema, outputStream);
                }
            };
        }
        throw new IllegalArgumentException("Serializer for the format not supplied");
    }
}

