/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializers;

import com.google.common.base.Preconditions;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.contract.data.SerializationFormat;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.EncodingCache;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.BiFunction;

class MultipleFormatDeserializer<T>
extends AbstractDeserializer<T> {
    private final Map<SerializationFormat, AbstractDeserializer> genericDeserializers;
    private final BiFunction<SerializationFormat, Object, T> transform;

    MultipleFormatDeserializer(String groupId, SchemaRegistryClient client, Map<SerializationFormat, AbstractDeserializer> genericDeserializers, SerializerConfig.Decoders decoders, EncodingCache encodingCache, BiFunction<SerializationFormat, Object, T> transform) {
        super(groupId, client, null, false, decoders, encodingCache, true);
        this.genericDeserializers = genericDeserializers;
        this.transform = transform;
    }

    @Override
    public final T deserialize(InputStream inputStream, SchemaInfo writerSchema, SchemaInfo readerSchema) throws IOException {
        Preconditions.checkNotNull(writerSchema);
        return this.transform.apply(writerSchema.getSerializationFormat(), this.genericDeserializers.get((Object)writerSchema.getSerializationFormat()).deserialize(inputStream, writerSchema, readerSchema));
    }
}

