/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializers;

import io.pravega.client.stream.Serializer;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractSerializer;
import io.pravega.schemaregistry.serializers.WithSchema;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.commons.lang3.NotImplementedException;

class MultipleFormatSerializer
implements Serializer<WithSchema<Object>> {
    private final Function<SchemaInfo, AbstractSerializer<Object>> serializerFunction;
    private final ConcurrentHashMap<SchemaInfo, AbstractSerializer<Object>> serializersMap;

    MultipleFormatSerializer(Function<SchemaInfo, AbstractSerializer<Object>> serializerFunction) {
        this.serializerFunction = serializerFunction;
        this.serializersMap = new ConcurrentHashMap();
    }

    public ByteBuffer serialize(WithSchema<Object> value) {
        AbstractSerializer serializer = this.serializersMap.computeIfAbsent(value.getSchema().getSchemaInfo(), x -> this.serializerFunction.apply(value.getSchema().getSchemaInfo()));
        return serializer.serialize(value.getObject());
    }

    public WithSchema<Object> deserialize(ByteBuffer serializedValue) {
        throw new NotImplementedException("Deserializer not implemented");
    }
}

