/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.shaded.io.swagger.models.properties;

import io.pravega.schemaregistry.shaded.io.swagger.models.Xml;
import io.pravega.schemaregistry.shaded.io.swagger.models.properties.AbstractProperty;
import io.pravega.schemaregistry.shaded.io.swagger.models.properties.Property;

public class ArrayProperty
extends AbstractProperty
implements Property {
    public static final String TYPE = "array";
    protected Boolean uniqueItems;
    protected Property items;
    private Integer maxItems;
    private Integer minItems;

    public ArrayProperty() {
        this.type = TYPE;
    }

    public ArrayProperty(Property items) {
        this.type = TYPE;
        this.setItems(items);
    }

    public static boolean isType(String type) {
        return TYPE.equals(type);
    }

    public ArrayProperty xml(Xml xml) {
        this.setXml(xml);
        return this;
    }

    public ArrayProperty uniqueItems() {
        this.setUniqueItems(true);
        return this;
    }

    @Override
    public ArrayProperty description(String description) {
        this.setDescription(description);
        return this;
    }

    @Override
    public ArrayProperty title(String title) {
        this.setTitle(title);
        return this;
    }

    public ArrayProperty example(Object example) {
        this.setExample(example);
        return this;
    }

    public ArrayProperty items(Property items) {
        this.setItems(items);
        return this;
    }

    public ArrayProperty vendorExtension(String key, Object obj) {
        this.setVendorExtension(key, obj);
        return this;
    }

    @Override
    public ArrayProperty readOnly() {
        this.setReadOnly(Boolean.TRUE);
        return this;
    }

    public Property getItems() {
        return this.items;
    }

    public void setItems(Property items) {
        this.items = items;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public void setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = Boolean.TRUE.equals(uniqueItems) ? Boolean.valueOf(true) : null;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public void setMinItems(Integer minItems) {
        this.minItems = minItems;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayProperty)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayProperty that = (ArrayProperty)o;
        if (this.uniqueItems != null ? !this.uniqueItems.equals(that.uniqueItems) : that.uniqueItems != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.maxItems != null ? !this.maxItems.equals(that.maxItems) : that.maxItems != null) {
            return false;
        }
        return this.minItems != null ? this.minItems.equals(that.minItems) : that.minItems == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.uniqueItems != null ? this.uniqueItems.hashCode() : 0);
        result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
        result = 31 * result + (this.maxItems != null ? this.maxItems.hashCode() : 0);
        result = 31 * result + (this.minItems != null ? this.minItems.hashCode() : 0);
        return result;
    }
}

