/*
 * Decompiled with CFR 0.152.
 */
package io.prestodb.tempto.internal.fulfillment.ldap;

import com.google.common.base.Preconditions;
import io.prestodb.tempto.fulfillment.ldap.LdapObjectDefinition;
import io.prestodb.tempto.internal.fulfillment.ldap.LdapObjectEntryManager;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLdapObjectEntryManager
implements LdapObjectEntryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLdapObjectEntryManager.class);
    private final String ldapUrl;
    private final String ldapAdminDistinguishedName;
    private final String ldapAdminPassword;

    @Inject
    public DefaultLdapObjectEntryManager(@Named(value="ldap.url") String ldapUrl, @Named(value="ldap.admin.dn") String ldapAdminDistinguishedName, @Named(value="ldap.admin.password") String ldapAdminPassword) {
        this.ldapUrl = Objects.requireNonNull(ldapUrl, "ldapUrl is null");
        this.ldapAdminDistinguishedName = Objects.requireNonNull(ldapAdminDistinguishedName, "ldapAdminDistinguishedName is null");
        this.ldapAdminPassword = Objects.requireNonNull(ldapAdminPassword, "ldapAdminPassword is null");
    }

    private DirContext createContext(String ldapUrl, String ldapAdminDistinguishedName, String ldapAdminPassword) {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        environment.put("java.naming.provider.url", ldapUrl);
        environment.put("java.naming.security.authentication", "simple");
        environment.put("java.naming.security.principal", ldapAdminDistinguishedName);
        environment.put("java.naming.security.credentials", ldapAdminPassword);
        try {
            return new InitialDirContext(environment);
        }
        catch (NamingException e) {
            throw new RuntimeException("Connection to LDAP server failed", e);
        }
    }

    private void closeQuietly(DirContext context) {
        try {
            if (context != null) {
                context.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private String addLdapDefinition(LdapObjectDefinition ldapObjectDefinition, DirContext context) {
        Preconditions.checkNotNull((Object)ldapObjectDefinition, (Object)"LDAP Object Definition is null");
        BasicAttributes entries = new BasicAttributes();
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        ldapObjectDefinition.getAttributes().forEach((k, v) -> entries.put(new BasicAttribute((String)k, v)));
        List modificationItems = ldapObjectDefinition.getModificationAttributes().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(attribute -> new ModificationItem(1, new BasicAttribute((String)entry.getKey(), attribute)))).collect(Collectors.toList());
        ldapObjectDefinition.getObjectClasses().forEach(objectClass::add);
        entries.put(objectClass);
        try {
            context.createSubcontext(ldapObjectDefinition.getDistinguishedName(), (Attributes)entries);
            context.modifyAttributes(ldapObjectDefinition.getDistinguishedName(), (ModificationItem[])modificationItems.stream().toArray(ModificationItem[]::new));
            LOGGER.info("Successfully added entry " + ldapObjectDefinition.getId());
        }
        catch (NameAlreadyBoundException e) {
            LOGGER.info(String.format("LDAP Entry %s already exists. Ignoring...", ldapObjectDefinition.getId()));
        }
        catch (NamingException e) {
            throw new RuntimeException("LDAP Entry addition failed", e);
        }
        return ldapObjectDefinition.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLdapDefinitions(List<LdapObjectDefinition> ldapObjectDefinitions) {
        DirContext context = this.createContext(this.ldapUrl, this.ldapAdminDistinguishedName, this.ldapAdminPassword);
        try {
            for (LdapObjectDefinition ldapObjectDefinition : ldapObjectDefinitions) {
                this.addLdapDefinition(ldapObjectDefinition, context);
            }
        }
        finally {
            this.closeQuietly(context);
        }
    }
}

