/*
 * Decompiled with CFR 0.152.
 */
package io.prestodb.tempto.logging;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.Files;
import com.google.inject.ConfigurationException;
import io.prestodb.tempto.context.TestContext;
import io.prestodb.tempto.context.ThreadLocalTestContextHolder;
import io.prestodb.tempto.internal.listeners.TestMetadata;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public class TestFrameworkLoggingAppender
extends AppenderSkeleton {
    private static final PatternLayout DEFAULT_FILE_OUTPUT_FORMAT = new PatternLayout("[%d{yyyy-MM-dd HH:mm:ss}] [%p] %c{10}: %m%n");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'_'HH-mm-ss");
    private final LoadingCache<String, PrintWriter> printWriterCache = this.buildPrintWriterCache();
    private final String logsDirectory = this.selectLogsDirectory();

    public TestFrameworkLoggingAppender() {
        this.setLayout((Layout)DEFAULT_FILE_OUTPUT_FORMAT);
    }

    private LoadingCache<String, PrintWriter> buildPrintWriterCache() {
        return CacheBuilder.newBuilder().maximumSize(20L).removalListener(rn -> ((PrintWriter)rn.getValue()).close()).build((CacheLoader)new CacheLoader<String, PrintWriter>(){

            public PrintWriter load(String fileName) throws Exception {
                File file = new File(fileName);
                Files.createParentDirs((File)file);
                return new PrintWriter(new FileOutputStream(file, true));
            }
        });
    }

    private String getRootLogsDirectory() {
        String userLogsDir = System.getProperty("io.prestodb.tempto.root.logs.dir");
        if (userLogsDir != null) {
            return userLogsDir;
        }
        return FileUtils.getTempDirectoryPath() + "/tempto_logs";
    }

    private String selectLogsDirectory() {
        return this.getRootLogsDirectory() + "/" + DATE_FORMAT.format(new Date());
    }

    protected void append(LoggingEvent event) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cannot append to a closed TestFrameworkLoggingAppender");
        this.writeToFile(this.getLayout().format(event));
        String[] throwableStack = event.getThrowableStrRep();
        if (throwableStack != null) {
            for (String throwableElement : throwableStack) {
                if (!this.getLayout().ignoresThrowable()) continue;
                this.writeToFile(this.formatThrowableElement(throwableElement));
            }
        }
    }

    private String formatThrowableElement(String throwableElement) {
        return "   " + throwableElement + "\n";
    }

    private void writeToFile(String message) {
        Optional<PrintWriter> printWriter = this.getFilePrintWriterForCurrentTest();
        if (printWriter.isPresent()) {
            printWriter.get().print(message);
            printWriter.get().flush();
        }
    }

    private Optional<PrintWriter> getFilePrintWriterForCurrentTest() {
        Optional<String> currentTestLogFileName = this.getCurrentTestLogFileName();
        if (currentTestLogFileName.isPresent()) {
            return Optional.of(this.getFilePrintWriter(currentTestLogFileName.get()));
        }
        return Optional.empty();
    }

    private PrintWriter getFilePrintWriter(String fileName) {
        return (PrintWriter)this.printWriterCache.getUnchecked((Object)fileName);
    }

    private Optional<String> getCurrentTestLogFileName() {
        Optional testContext = ThreadLocalTestContextHolder.testContextIfSet();
        try {
            Optional testMetadata;
            String testName = "SUITE";
            if (testContext.isPresent() && (testMetadata = ((TestContext)testContext.get()).getOptionalDependency(TestMetadata.class)).isPresent()) {
                testName = ((TestMetadata)testMetadata.get()).testName;
            }
            return Optional.of(this.logsDirectory + "/" + testName);
        }
        catch (ConfigurationException e) {
            System.err.append("Could not load TestMetadata from guice context");
            return Optional.empty();
        }
    }

    public void close() {
        this.closed = true;
        this.printWriterCache.invalidateAll();
        this.printWriterCache.cleanUp();
    }

    public boolean requiresLayout() {
        return true;
    }

    public static Optional<String> getSelectedLogsDirectory() {
        Enumeration allAppenders = Logger.getRootLogger().getAllAppenders();
        while (allAppenders.hasMoreElements()) {
            Appender appender = (Appender)allAppenders.nextElement();
            if (!(appender instanceof TestFrameworkLoggingAppender)) continue;
            return Optional.of(((TestFrameworkLoggingAppender)appender).logsDirectory);
        }
        return Optional.empty();
    }
}

