/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchto.driver.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import io.prestosql.benchto.driver.Benchmark;
import io.prestosql.benchto.driver.BenchmarkExecutionException;
import io.prestosql.benchto.driver.Query;
import io.prestosql.benchto.driver.concurrent.ExecutorServiceFactory;
import io.prestosql.benchto.driver.execution.BenchmarkExecutionResult;
import io.prestosql.benchto.driver.execution.ExecutionSynchronizer;
import io.prestosql.benchto.driver.execution.QueryExecution;
import io.prestosql.benchto.driver.execution.QueryExecutionDriver;
import io.prestosql.benchto.driver.execution.QueryExecutionResult;
import io.prestosql.benchto.driver.listeners.benchmark.BenchmarkStatusReporter;
import io.prestosql.benchto.driver.macro.MacroService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class BenchmarkExecutionDriver {
    private static final Logger LOG = LoggerFactory.getLogger(BenchmarkExecutionDriver.class);
    @Autowired
    private QueryExecutionDriver queryExecutionDriver;
    @Autowired
    private BenchmarkStatusReporter statusReporter;
    @Autowired
    private ExecutorServiceFactory executorServiceFactory;
    @Autowired
    private MacroService macroService;
    @Autowired
    private ExecutionSynchronizer executionSynchronizer;
    @Autowired
    private ApplicationContext applicationContext;

    public BenchmarkExecutionResult execute(Benchmark benchmark, int benchmarkOrdinalNumber, int benchmarkTotalCount) {
        LOG.info("[{} of {}] processing benchmark: {}", new Object[]{benchmarkOrdinalNumber, benchmarkTotalCount, benchmark});
        BenchmarkExecutionResult benchmarkExecutionResult = null;
        try {
            this.macroService.runBenchmarkMacros(benchmark.getBeforeBenchmarkMacros(), benchmark);
            benchmarkExecutionResult = this.executeBenchmark(benchmark);
            this.macroService.runBenchmarkMacros(benchmark.getAfterBenchmarkMacros(), benchmark);
            return benchmarkExecutionResult;
        }
        catch (Exception e) {
            if (benchmarkExecutionResult == null || benchmarkExecutionResult.isSuccessful()) {
                return this.failedBenchmarkResult(benchmark, e);
            }
            Preconditions.checkState((!benchmarkExecutionResult.isSuccessful() ? 1 : 0) != 0, (Object)"Benchmark is already failed.");
            LOG.error("Error while running after benchmark macros for successful benchmark({})", benchmark.getAfterBenchmarkMacros(), (Object)e);
            return benchmarkExecutionResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BenchmarkExecutionResult executeBenchmark(Benchmark benchmark) {
        List<QueryExecutionResult> executions;
        BenchmarkExecutionResult.BenchmarkExecutionResultBuilder resultBuilder = new BenchmarkExecutionResult.BenchmarkExecutionResultBuilder(benchmark);
        try {
            this.executeQueries(benchmark, benchmark.getPrewarmRuns(), false);
            this.executionSynchronizer.awaitAfterBenchmarkExecutionAndBeforeResultReport(benchmark);
            this.statusReporter.reportBenchmarkStarted(benchmark);
            resultBuilder = (BenchmarkExecutionResult.BenchmarkExecutionResultBuilder)resultBuilder.startTimer();
            try {
                executions = this.executeQueries(benchmark, benchmark.getRuns(), true);
            }
            finally {
                resultBuilder = (BenchmarkExecutionResult.BenchmarkExecutionResultBuilder)resultBuilder.endTimer();
            }
        }
        catch (RuntimeException e) {
            return resultBuilder.withUnexpectedException(e).build();
        }
        BenchmarkExecutionResult executionResult = resultBuilder.withExecutions(executions).build();
        this.statusReporter.reportBenchmarkFinished(executionResult);
        return executionResult;
    }

    private BenchmarkExecutionResult failedBenchmarkResult(Benchmark benchmark, Exception e) {
        return new BenchmarkExecutionResult.BenchmarkExecutionResultBuilder(benchmark).withUnexpectedException(e).build();
    }

    private List<QueryExecutionResult> executeQueries(Benchmark benchmark, int runs, boolean reportStatus) {
        ListeningExecutorService executorService = this.executorServiceFactory.create(benchmark.getConcurrency());
        try {
            List<Callable<QueryExecutionResult>> queryExecutionCallables = this.buildQueryExecutionCallables(benchmark, runs, reportStatus);
            List executionFutures = executorService.invokeAll(queryExecutionCallables);
            List list = (List)Futures.allAsList((Iterable)executionFutures).get();
            return list;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new BenchmarkExecutionException("Could not execute benchmark", e);
        }
        finally {
            executorService.shutdown();
        }
    }

    private List<Callable<QueryExecutionResult>> buildQueryExecutionCallables(Benchmark benchmark, int runs, boolean reportStatus) {
        ArrayList executionCallables = Lists.newArrayList();
        for (Query query : benchmark.getQueries()) {
            for (int run = 1; run <= runs; ++run) {
                QueryExecution queryExecution = new QueryExecution(benchmark, query, run);
                executionCallables.add(() -> {
                    QueryExecutionResult result;
                    try (Connection connection = this.getConnectionFor(queryExecution);){
                        this.macroService.runBenchmarkMacros(benchmark.getBeforeExecutionMacros(), benchmark, connection);
                        if (reportStatus) {
                            this.statusReporter.reportExecutionStarted(queryExecution);
                        }
                        QueryExecutionResult.QueryExecutionResultBuilder failureResult = (QueryExecutionResult.QueryExecutionResultBuilder)new QueryExecutionResult.QueryExecutionResultBuilder(queryExecution).startTimer();
                        try {
                            result = this.queryExecutionDriver.execute(queryExecution, connection);
                        }
                        catch (Exception e) {
                            LOG.error("Query Execution failed for benchmark {}", (Object)benchmark.getName());
                            result = (QueryExecutionResult)((QueryExecutionResult.QueryExecutionResultBuilder)failureResult.endTimer()).failed(e).build();
                        }
                        if (reportStatus) {
                            this.statusReporter.reportExecutionFinished(result);
                        }
                        this.macroService.runBenchmarkMacros(benchmark.getAfterExecutionMacros(), benchmark, connection);
                    }
                    return result;
                });
            }
        }
        return executionCallables;
    }

    private Connection getConnectionFor(QueryExecution queryExecution) throws SQLException {
        return ((DataSource)this.applicationContext.getBean(queryExecution.getBenchmark().getDataSource(), DataSource.class)).getConnection();
    }
}

