/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchto.driver.listeners.benchmark;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.collect.Queues;
import io.prestosql.benchto.driver.Benchmark;
import io.prestosql.benchto.driver.execution.BenchmarkExecutionResult;
import io.prestosql.benchto.driver.execution.QueryExecution;
import io.prestosql.benchto.driver.execution.QueryExecutionResult;
import io.prestosql.benchto.driver.listeners.benchmark.BenchmarkExecutionListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.OrderComparator;
import org.springframework.stereotype.Component;

@Component
public class BenchmarkStatusReporter {
    private static final Logger LOG = LoggerFactory.getLogger(BenchmarkStatusReporter.class);
    private final List<BenchmarkExecutionListener> executionListeners;
    private Queue<Future<?>> pendingFutures = Queues.synchronizedQueue(new ArrayDeque());

    @Autowired
    public BenchmarkStatusReporter(List<BenchmarkExecutionListener> executionListeners) {
        this.executionListeners = ImmutableList.copyOf((Collection)Ordering.from((arg_0, arg_1) -> ((OrderComparator)OrderComparator.INSTANCE).compare(arg_0, arg_1)).compound((Comparator)Ordering.usingToString()).sortedCopy(executionListeners));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCompletedFutures() {
        Queue<Future<?>> queue = this.pendingFutures;
        synchronized (queue) {
            while (!this.pendingFutures.isEmpty() && this.pendingFutures.element().isDone()) {
                Future<?> doneFuture = this.pendingFutures.remove();
                try {
                    doneFuture.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Interrupted when retrieving result of an already done future", e);
                }
                catch (CancellationException | ExecutionException e) {
                    throw new RuntimeException("Listener failed with: " + e, e);
                }
            }
        }
    }

    public void awaitAllFutures(long timeout, TimeUnit unit) {
        this.processCompletedFutures();
        List<Future<?>> futures = this.drainFutures();
        LOG.info("Awaiting completion of {} futures", (Object)futures.size());
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (Future<?> future : futures) {
            long remainingNanos = unit.toNanos(timeout) - stopwatch.elapsed(TimeUnit.NANOSECONDS);
            remainingNanos = Math.max(remainingNanos, 0L);
            try {
                future.get(remainingNanos, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted when retrieving result of an already done future", e);
            }
            catch (CancellationException | ExecutionException | TimeoutException e) {
                throw new RuntimeException("Failure when waiting for listener completion: " + e, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Future<?>> drainFutures() {
        Queue<Future<?>> queue = this.pendingFutures;
        synchronized (queue) {
            ArrayList futures = new ArrayList(this.pendingFutures);
            this.pendingFutures.clear();
            return futures;
        }
    }

    public void reportBenchmarkStarted(Benchmark benchmark) {
        this.fireListeners(BenchmarkExecutionListener::benchmarkStarted, benchmark);
    }

    public void reportBenchmarkFinished(BenchmarkExecutionResult benchmarkExecutionResult) {
        this.fireListeners(BenchmarkExecutionListener::benchmarkFinished, benchmarkExecutionResult);
    }

    public void reportExecutionStarted(QueryExecution queryExecution) {
        this.fireListeners(BenchmarkExecutionListener::executionStarted, queryExecution);
    }

    public void reportExecutionFinished(QueryExecutionResult queryExecutionResult) {
        this.fireListeners(BenchmarkExecutionListener::executionFinished, queryExecutionResult);
    }

    private <T> void fireListeners(BiFunction<BenchmarkExecutionListener, T, Future<?>> invoker, T argument) {
        ArrayList futures = new ArrayList();
        for (BenchmarkExecutionListener listener : this.executionListeners) {
            futures.add(invoker.apply(listener, (BenchmarkExecutionListener)argument));
        }
        this.pendingFutures.addAll(futures);
    }
}

