/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchto.driver.listeners.measurements;

import com.google.common.collect.ImmutableList;
import io.prestosql.benchto.driver.Measurable;
import io.prestosql.benchto.driver.execution.BenchmarkExecutionResult;
import io.prestosql.benchto.driver.listeners.measurements.PostExecutionMeasurementProvider;
import io.prestosql.benchto.driver.service.Measurement;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.stereotype.Component;

@Component
public class ThroughputMeasurementProvider
implements PostExecutionMeasurementProvider {
    @Override
    public CompletableFuture<List<Measurement>> loadMeasurements(Measurable measurable) {
        ImmutableList measurements = measurable instanceof BenchmarkExecutionResult && measurable.getBenchmark().isConcurrent() && measurable.isSuccessful() ? ImmutableList.of((Object)Measurement.measurement("throughput", "QUERY_PER_SECOND", this.calculateThroughput((BenchmarkExecutionResult)measurable))) : Collections.emptyList();
        return CompletableFuture.completedFuture(measurements);
    }

    private double calculateThroughput(BenchmarkExecutionResult benchmarkExecutionResult) {
        long durationInMillis = benchmarkExecutionResult.getQueryDuration().toMillis();
        return (double)benchmarkExecutionResult.getExecutions().size() / (double)durationInMillis * 1000.0;
    }
}

