/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchto.driver.loader;

import com.google.common.collect.ImmutableSet;
import io.prestosql.benchto.driver.utils.YamlUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class BenchmarkDescriptor {
    public static final String DATA_SOURCE_KEY = "datasource";
    public static final String QUERY_NAMES_KEY = "query-names";
    public static final String RUNS_KEY = "runs";
    public static final String PREWARM_RUNS_KEY = "prewarm-runs";
    public static final String CONCURRENCY_KEY = "concurrency";
    public static final String BEFORE_BENCHMARK_MACROS_KEY = "before-benchmark";
    public static final String AFTER_BENCHMARK_MACROS_KEY = "after-benchmark";
    public static final String BEFORE_EXECUTION_MACROS_KEY = "before-execution";
    public static final String AFTER_EXECUTION_MACROS_KEY = "after-execution";
    public static final String VARIABLES_KEY = "variables";
    public static final String QUARANTINE_KEY = "quarantine";
    public static final String FREQUENCY_KEY = "frequency";
    public static final Set<String> RESERVED_KEYWORDS = ImmutableSet.of((Object)"datasource", (Object)"query-names", (Object)"runs", (Object)"prewarm-runs", (Object)"concurrency", (Object)"before-benchmark", (Object[])new String[]{"after-benchmark", "before-execution", "after-execution", "variables", "quarantine", "frequency"});
    private final Map<String, String> variables;

    public BenchmarkDescriptor(Map<String, String> variables) {
        this.variables = variables;
        this.variables.putIfAbsent(QUARANTINE_KEY, "false");
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public String getDataSource() {
        return this.variables.get(DATA_SOURCE_KEY);
    }

    public List<String> getQueryNames() {
        return YamlUtils.asStringList(this.variables.get(QUERY_NAMES_KEY));
    }

    public Optional<Integer> getRuns() {
        return this.getIntegerOptional(RUNS_KEY);
    }

    public Optional<Integer> getPrewarmRepeats() {
        return this.getIntegerOptional(PREWARM_RUNS_KEY);
    }

    public Optional<Integer> getConcurrency() {
        return this.getIntegerOptional(CONCURRENCY_KEY);
    }

    public Optional<Integer> getFrequency() {
        return this.getIntegerOptional(FREQUENCY_KEY);
    }

    public List<String> getBeforeBenchmarkMacros() {
        return YamlUtils.asStringList(this.variables.getOrDefault(BEFORE_BENCHMARK_MACROS_KEY, ""));
    }

    public List<String> getAfterBenchmarkMacros() {
        return YamlUtils.asStringList(this.variables.getOrDefault(AFTER_BENCHMARK_MACROS_KEY, ""));
    }

    public List<String> getBeforeExecutionMacros() {
        return YamlUtils.asStringList(this.variables.getOrDefault(BEFORE_EXECUTION_MACROS_KEY, ""));
    }

    public List<String> getAfterExecutionMacros() {
        return YamlUtils.asStringList(this.variables.getOrDefault(AFTER_EXECUTION_MACROS_KEY, ""));
    }

    private Optional<Integer> getIntegerOptional(String key) {
        if (this.variables.containsKey(key)) {
            return Optional.of(Integer.valueOf(this.variables.get(key)));
        }
        return Optional.empty();
    }
}

