/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchto.driver.loader;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.prestosql.benchto.driver.BenchmarkExecutionException;
import io.prestosql.benchto.driver.Query;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

@Component
public class SqlStatementGenerator {
    private static final Splitter SQL_STATEMENT_SPLITTER = Splitter.on((String)";").trimResults().omitEmptyStrings();
    @Autowired
    private Configuration freemarkerConfiguration;

    public List<String> generateQuerySqlStatement(Query query, Map<String, ?> attributes) {
        ImmutableList.Builder sqlQueries = ImmutableList.builder();
        String sqlTemplate = this.generateQuerySqlStatement(query.getSqlTemplate(), attributes);
        for (String sqlQuery : SqlStatementGenerator.toSqlQueries(sqlTemplate)) {
            sqlQueries.add((Object)sqlQuery);
        }
        return sqlQueries.build();
    }

    private static ImmutableList<String> toSqlQueries(String sqlTemplate) {
        return ImmutableList.copyOf((Iterable)SQL_STATEMENT_SPLITTER.split((CharSequence)sqlTemplate));
    }

    private String generateQuerySqlStatement(String sqlTemplate, Map<String, ?> attributes) {
        try {
            String templateName = UUID.randomUUID().toString();
            Template queryTemplate = new Template(templateName, (Reader)new StringReader(sqlTemplate), this.freemarkerConfiguration);
            return FreeMarkerTemplateUtils.processTemplateIntoString((Template)queryTemplate, attributes);
        }
        catch (TemplateException | IOException e) {
            throw new BenchmarkExecutionException(e);
        }
    }
}

