/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchto.driver.macro;

import io.prestosql.benchto.driver.Benchmark;
import io.prestosql.benchto.driver.macro.MacroExecutionDriver;
import io.prestosql.benchto.driver.macro.MacroService;
import java.sql.Connection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MacroServiceImpl
implements MacroService {
    @Autowired
    private List<MacroExecutionDriver> macroExecutionDrivers;

    @Override
    public void runBenchmarkMacro(String macroName, Optional<Benchmark> benchmark, Optional<Connection> connection) {
        MacroExecutionDriver macroExecutionDriver = this.macroExecutionDrivers.stream().filter(executionDriver -> executionDriver.canExecuteBenchmarkMacro(macroName)).collect(Collectors.collectingAndThen(Collectors.toList(), matchingExecutionDrivers -> {
            if (matchingExecutionDrivers.size() > 1) {
                throw new IllegalStateException(String.format("More than one execution driver for macro %s - matching drivers %s", macroName, matchingExecutionDrivers));
            }
            if (matchingExecutionDrivers.size() == 0) {
                throw new IllegalStateException(String.format("No execution driver for macro %s", macroName));
            }
            return (MacroExecutionDriver)matchingExecutionDrivers.get(0);
        }));
        macroExecutionDriver.runBenchmarkMacro(macroName, benchmark, connection);
    }
}

