/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchto.driver.utils;

import java.nio.file.Path;
import java.util.Comparator;

public class NaturalOrderComparator
implements Comparator<String> {
    private static final Comparator<String> FOR_STRINGS = new NaturalOrderComparator();
    private static final Comparator<Path> FOR_PATHS = (o1, o2) -> NaturalOrderComparator.forStrings().compare(o1.toString(), o2.toString());

    public static Comparator<String> forStrings() {
        return FOR_STRINGS;
    }

    public static Comparator<Path> forPaths() {
        return FOR_PATHS;
    }

    @Override
    public int compare(String a, String b) {
        int ia = 0;
        int ib = 0;
        while (true) {
            int result;
            int nza = 0;
            int nzb = 0;
            char ca = this.charAt(a, ia);
            char cb = this.charAt(b, ib);
            while (Character.isSpaceChar(ca) || ca == '0') {
                nza = ca == '0' ? ++nza : 0;
                ca = this.charAt(a, ++ia);
            }
            while (Character.isSpaceChar(cb) || cb == '0') {
                nzb = cb == '0' ? ++nzb : 0;
                cb = this.charAt(b, ++ib);
            }
            if (Character.isDigit(ca) && Character.isDigit(cb) && (result = this.compareRight(a.substring(ia), b.substring(ib))) != 0) {
                return result;
            }
            if (ca == '\u0000' && cb == '\u0000') {
                return nza - nzb;
            }
            if (ca < cb) {
                return -1;
            }
            if (ca > cb) {
                return 1;
            }
            ++ia;
            ++ib;
        }
    }

    private int compareRight(String a, String b) {
        int bias = 0;
        int ia = 0;
        int ib = 0;
        while (true) {
            char ca = this.charAt(a, ia);
            char cb = this.charAt(b, ib);
            if (!Character.isDigit(ca) && !Character.isDigit(cb)) {
                return bias;
            }
            if (!Character.isDigit(ca)) {
                return -1;
            }
            if (!Character.isDigit(cb)) {
                return 1;
            }
            if (ca < cb) {
                if (bias == 0) {
                    bias = -1;
                }
            } else if (ca > cb) {
                if (bias == 0) {
                    bias = 1;
                }
            } else if (ca == '\u0000' && cb == '\u0000') {
                return bias;
            }
            ++ia;
            ++ib;
        }
    }

    private char charAt(String s, int i) {
        if (i >= s.length()) {
            return '\u0000';
        }
        return s.charAt(i);
    }

    private NaturalOrderComparator() {
    }
}

