/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchto.driver.utils;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryUtils.class);
    private static final int LOGGED_ROWS = 10;

    public static int fetchRows(String sqlStatement, ResultSet resultSet) throws SQLException {
        LOGGER.info("First {} rows for query: {}", (Object)10, (Object)sqlStatement);
        int rowsCount = 0;
        while (resultSet.next()) {
            if (rowsCount < 10) {
                QueryUtils.logRow(rowsCount + 1, resultSet);
            } else if (rowsCount == 10) {
                LOGGER.info("There are more unlogged rows");
            }
            ++rowsCount;
        }
        return rowsCount;
    }

    private static void logRow(int rowNumber, ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        StringJoiner joiner = new StringJoiner("; ", "[", "]");
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            joiner.add(resultSetMetaData.getColumnName(i) + ": " + resultSet.getObject(i));
        }
        LOGGER.info("Row: " + rowNumber + ", column values: " + joiner.toString());
    }

    private QueryUtils() {
    }
}

