/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchto.driver.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.yaml.snakeyaml.Yaml;

public final class YamlUtils {
    public static Map<Object, Object> loadYamlFromPath(Path path) throws IOException {
        return YamlUtils.loadYamlFromString(new String(Files.readAllBytes(path), StandardCharsets.UTF_8));
    }

    public static Map<Object, Object> loadYamlFromString(String string) {
        Yaml yaml = new Yaml();
        return Optional.ofNullable((Map)yaml.load(string)).orElse((Map)ImmutableMap.of());
    }

    public static Map<String, List<String>> stringifyMultimap(Map<Object, Object> variableMap) {
        return variableMap.entrySet().stream().map(entry -> Maps.immutableEntry((Object)entry.getKey().toString(), YamlUtils.asStringList(Objects.requireNonNull(entry.getValue(), "Null value for key: " + entry.getKey())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static List<String> asStringList(Object object) {
        if (!(object instanceof Iterable)) {
            return ImmutableList.copyOf((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)object.toString()));
        }
        Iterable iterable = (Iterable)object;
        return StreamSupport.stream(iterable.spliterator(), false).map(Object::toString).collect(Collectors.toList());
    }

    private YamlUtils() {
    }
}

